/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Error.c	1.8 84/10/31
*/

/*
**	Error handlers.
*/

#define	FILE_CONTROL
#define	RECOVER
#define	STDIO

#include	"global.h"
#include	"debug.h"

#include	<errno.h>



jmp_buf		ErrBuf;
ERC_t		ErrFlag;
static bool	ErrIsatty;
static bool	IsattyDone;

#define	Fprintf	(void)fprintf
#define	Fflush	(void)fflush

extern char *	Name;
extern char *	sys_errlist[];
extern int	sys_nerr;

extern void	finish();


/*VARARGS2*/
void
Mesg(mesg, s, a1, a2, a3, a4, a5, a6)
	char *	mesg;
	char *	s;
	char *	a1;
	char *	a2;
	char *	a3;
	char *	a4;
	char *	a5;
	char *	a6;
{
	long	t;

	if ( !IsattyDone )
		(void)ErrorTty((int *)0);

	if ( !ErrIsatty )
	{
		(void)time(&t);
		(void)fseek(stderr, (long)0, 2);
		Fprintf(stderr, "%.15s ", ctime(&t)+4);
	}
	Fprintf(stderr, "%s: ", Name);
	if ( mesg != NULLSTR )
		Fprintf(stderr, "%s -- ", mesg);
	if ( strchr(s, '%') == NULLSTR )
		Fprintf(stderr, "%s", s);	/* To bypass an old '_doprnt' bug! */
	else
		Fprintf(stderr, s, a1, a2, a3, a4, a5, a6);
}



/*VARARGS1*/
void
Error(s, a1, a2, a3, a4, a5, a6)
	char *	s;
	char *	a1;
	char *	a2;
	char *	a3;
	char *	a4;
	char *	a5;
	char *	a6;
{
	(void)alarm(0);

	Mesg("error", s, a1, a2, a3, a4, a5, a6);
	putc('\n', stderr);
	Fflush(stderr);

	errno = 0;

	switch ( ErrFlag )
	{
	case ert_here:
		longjmp(ErrBuf, 1);
	case ert_finish:
		finish(1);
	}
}



/*VARARGS1*/
void
Syserror(s, a1, a2, a3, a4, a5, a6)
	char *		s;
	char *		a1;
	char *		a2;
	char *		a3;
	char *		a4;
	char *		a5;
	char *		a6;
{
	register int	en;

	if ( (en = errno) == EINTR )
		return;

	(void)alarm(0);

	Mesg("system error", s, a1, a2, a3, a4, a5, a6);

	if ( en < sys_nerr )
		Fprintf(stderr, ": %s\n", sys_errlist[en]);
	else
		Fprintf(stderr, ": Error %d\n", en);

	Fflush(stderr);

	switch ( en )
	{
	case ECHILD:
		return;
	case ENFILE:
	case ENOSPC:
	case EAGAIN:
		sleep(60);
		return;
	}

	errno = en;

	finish(SYSERROR);
}



bool
ErrorTty(fdp)
	int *	fdp;
{
	if ( !IsattyDone )
	{
		ErrIsatty = (bool)isatty(fileno(stderr));
		IsattyDone = true;
	}

	if ( fdp != (int *)0 )
		*fdp = fileno(stderr);

	return ErrIsatty;
}
