/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)WriteHeader.c	1.1 84/06/12
*/

/*
**	Write out header at end of file.
**
**	Assumes that "HdrFields" has been set up properly.
**
**	Result, if not SYSERROR, is the number of bytes in the header.
*/

#include	"global.h"

#include	"debug.h"
#include	"header.h"



int
WriteHeader(fd, start, minlength)
	int			fd;
	long			start;
	int			minlength;
{
	register char **	fp;
	register int		n;
	register char *		cp;
	register int		r;
	register int		bytes;
	Crc_t			crc;
	char			length[HDR_LENGTH_SIZE+1];

	(void)lseek(fd, start, 0);

	HdrFields.hf_start[(int)ht_type] = HDR_TYP1;

	for
	(
		fp = HdrFields.hf_start, crc = 0, bytes = 0 ;
		fp < &HdrFields.hf_start[NHDRFIELDS] ;
		fp++
	)
	{
		if ( (cp = *fp) == NULLSTR )
		{
			cp = "";
			n = 1;
		}
		else
			n = strlen(cp)+1;	/* Add 1 for null */

		bytes += n;

		crc = acrc(crc, cp, n);

		while ( (r = write(fd, cp, n)) != n )
		{
			if ( r == SYSERROR )
				return SYSERROR;
			cp += r;
			n -= r;
		}
	}

	if ( minlength > HDR_LENGTH_SIZE )
	{
		minlength -= HDR_LENGTH_SIZE;

		while ( (n = minlength-bytes) > 0 )
		{
			if ( n > sizeof length )
				n = sizeof length;
			
			strclr(length, n);

			if ( write(fd, length, n) != n )
				return SYSERROR;
			
			crc = acrc(crc, length, n);

			bytes += n;
		}
	}

	cp = length;
	*cp++ = LOCRC(crc);
	*cp = HICRC(crc);

	DODEBUG(if(CRC_SIZE!=2)Fatal("CRC_SIZE"));

	if ( write(fd, length, CRC_SIZE) != CRC_SIZE )
		return SYSERROR;

	bytes += CRC_SIZE;

	(void)strclr(length, sizeof length);
	(void)sprintf(length, "%d", bytes);

	if ( write(fd, length, HDR_LENGTH_SIZE) != HDR_LENGTH_SIZE )
		return SYSERROR;

	return HdrLength = bytes + HDR_LENGTH_SIZE;
}
