/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)GetEnv.c	1.2 84/06/29
*/

/*
**	Extract an environment field tagged by 'name'.
**	If the field exists, a pointer will be returned to reallocated field,
**	even if the field is empty; otherwise NULLSTR wil be returned.
*/

#include	"global.h"
#include	"header.h"


extern char	EnvRestricted[];
extern void	UnQuoteChars();



char *
GetEnv(name)
	char *		name;
{
	register char *	ep;
	register char *	fp;
	register char *	sp;
	register int	val;

	if ( (ep = HdrEnv) == NULLSTR )
		return NULLSTR;

	for ( ;; )
	{
		if ( (sp = strchr(ep, ENV_RS)) != NULLSTR )
			*sp = '\0';
		
		if ( (fp = strchr(ep, ENV_SEP)) != NULLSTR )
			val = strncmp(name, ep, fp-ep);
		else
			val = strcmp(name, ep);
		
		if ( val == STREQUAL )
		{
			if ( fp != NULLSTR && sp != NULLSTR )
			{
				ep = Malloc((sp-fp)+1);
				(void)strcpy(ep, fp+1);
			}
			else
			if ( fp != NULLSTR )
			{
				ep = Malloc(strlen(fp));
				(void)strcpy(ep, fp+1);
			}
			else
			{
				ep = Malloc(1);
				*ep = '\0';
			}

			if ( sp != NULLSTR )
				*sp = ENV_RS;
			
			UnQuoteChars(ep, EnvRestricted);

			return ep;
		}

		if ( (ep = sp) == NULLSTR )
			break;

		*ep++ = ENV_RS;
	}

	return NULLSTR;
}
