/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ExDests.c	1.1 84/06/12
*/

/*
**	Extract destinations from destination address,
**	and pass them back in order.
**
**	Returns false if error or !*funcp.
*/

#include	"global.h"
#include	"address.h"



bool
ExDests(cp, funcp)
	char *		cp;
	bool		(*funcp)();
{
	register char *	cp1;
	register char *	cp2;

	if ( (cp1 = cp) == NULLSTR )
		return false;

	switch ( *cp1++ )
	{
	case ATYP_BROADCAST:
		return (*funcp)(HomeNode);	/* Just consider this node */

	case ATYP_MULTICAST:
		for ( ;; )
		{
			if ( (cp2 = strchr(cp1, ATYP_MULTICAST)) == NULLSTR )
			{
				if ( cp1 == &cp[1] )
					return false;
			}
			else
				*cp2 = '\0';

			if ( !(*funcp)(cp1) )
			{
				if ( cp2 != NULLSTR )
					*cp2 = ATYP_MULTICAST;
				
				return false;
			}

			if ( (cp1 = cp2) == NULLSTR )
				break;
			
			*cp1++ = ATYP_MULTICAST;
		}

		return true;

	case ATYP_EXPLICIT:
		if ( (cp2 = strrchr(cp1, ATYP_EXPLICIT)) == NULLSTR )
			return false;
		
		return (*funcp)(cp2+1);
	}

	return (*funcp)(cp);
}
