/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)AtHome.c	1.2 84/06/15
*/

/*
**	Return 'true' if 'HomeNode' in destination list.
**
**	(Used in FthTo list searches.)
*/

#include	"global.h"
#include	"address.h"



bool
AtHome(s)
	register char *	s;
{
	register char *	a;
	char *		handler;	/* Not used */

	if
	(
		s[0] == ATYP_BROADCAST
		&&
		(
			s[1] == '\0'
			||
			(
				s[1] == DOMAIN_SEP
				&&
				(
					(
						s[2] == ATYP_BROADCAST
						&&
						s[3] == '\0'
					)
					||
					HomeDomain(&s[2], &handler)
				)
			)
		)
	)
		return true;
	
	if ( (a = strrchr(s, ATYP_EXPLICIT)) != NULLSTR )
		s = a + 1;
	else
		while ( (a = strchr(s, ATYP_MULTICAST)) != NULLSTR )
		{
			*a = '\0';

			if ( HomeAddress(s, &handler) )
				return true;

			*a++ = ATYP_MULTICAST;
			s = a;
		}

	if ( HomeAddress(s, &handler) )
		return true;

	return false;
}
