#include "mailer.h"
#include <ctype.h>

/*  We use \045 not % below, to prevent problems if this source file itself is
    transferred via mail from VMS to Unix  */

struct	ex	readerror[] =
{
	{ "\045MAIL-E-NOMSGS",		nomessages },
	{ "\045MAIL-E-NOTEXIST",	nomessages },
	{ "\045MAIL-E-OPENIN",		nomessages },
	{ "\045MAIL-E-NOMOREMSG",	nomessages },
	{ "\045MAIL-E-NOTREADIN",	nomessages },
	{ (char *) 0, 0 }
};

struct	ex	senderror[] =
{
	{ "\045MAIL-E-NOSUCHUSR",	recorderrmsg },
	{ "\045MAIL-E-USERDSABL",	recorderrmsg },
	{ "\045MAIL-E-LOGLINK",	recorderrmsg },
	{ "\045MAIL-E-SYNTAX",	recorderrmsg },
	{ "\045MAIL-E-OPENIN",	recorderrmsg },	/* in case of @ distrib file */
	{ "\045LIB-E-ACTIMAGE",	recorderrmsg },	/* in case of % protocol */
	{ (char *) 0, 0 }
};

struct	command maildir[] =
{
	{ "dir\r", "\nMAIL> ", JUNKTOFUNC, senddir },
	{ (char *) 0, (char *) 0, 0, 0 }
};

struct	command	readmail[] =
{
	{ "read\r", "\nMAIL> ", JUNKTOFUNC, rmail },
	{ "delete\r", "MAIL> ", SKIPTOPROMPT, 0 },
	{ (char *) 0, (char *) 0, 0 , 0 }
};

struct	command sendmail[] =
{
	{ "send\r", "To:", SKIPTOPROMPT, 0 },
	{ tostr, "Subj:", SKIPTOPROMPT, 0 },
	{ subjstr, "uit:\n", JUNKTOFUNC, smail }, /* Kludge. smail actuall sends mail */
	{ "\32", "MAIL> ", SKIPTOPROMPT, 0 },
	{ (char *) 0, (char *) 0, 0, 0 }
};

static 	int	doneheader = 0;
static	char	from[128];
static	char	month[20];
static	char	weekday[20];
static	int	day;
static	int	hour;
static	int	year;
static	int	minute;
static	int	second;
static	long	outstart;	/* value of outcount at start of message */
static	long	instart;	/* sim - used for ROUGH char & segment counts */

/* munnari charges for each 64-character segment or part thereof */

#define	NSEGS(nchars)	((nchars+63)/64)

rmail(s,moreflag)
char	*s;
int	moreflag;
{
	/* Process each mail record */
	int	count;
	int	i;
	char	*p;
	char	*q;
	char	*timestr;
	char	*ctime();
	long	ntime;
	char	unixmonth[20];
	int	unixday;
	int	unixyear;
	char	account[30];
	char	machine[30];


	donemail = 0;
	p = s;
	if(!doneheader)
	{
		if(novmsmessages == 1)
			return;
		if ((p = scanto("\n    #",s)) == (char *) 0)
		{
			fprintf(stderr,"Oh dear, no VMS # field!\n");
			return;
		}

		time(&ntime);
		timestr = ctime(&ntime);
		sscanf(timestr,"%s %s %d %*d:%*d:%*d %d",weekday,unixmonth,
			&unixday,&unixyear);

		count = sscanf(p,"%*d %d-%3c-%d %d:%d:%d", &day,
			&month[0], &year, &hour, &minute, &second);

		if (count == 6)
		{
		    maptolower(&month[1]);
		    if ( (day != unixday) || (year != unixyear)
				|| (strcmp(month,unixmonth) != 0) )
		    {
			strcpy(weekday,"Day");
			fprintf(stderr,
			"VMS date %d %s %d differs from Unix date %d %s %d",
			day, month, year, unixday, unixmonth, unixyear );
		    }
		}
		else
		{
			fprintf(stderr,"Bad VMS # field count = %d\n",count);
			sscanf(timestr,"%s %s %d %d:%d:%d %d",
				weekday,month,&day,&hour,&minute,&second,&year);
		}

		if ( (p = scanto("\nFrom:",s)) == (char *) 0)
		{
			fprintf(stderr,"Oh Dear, no VMS From: field!\n");
			return;
		}
		sscanf(p," %s",&from[0]);
		maptolower(&from[0]);
		remove_node_name(&from[0]);
		doneheader = 1;


		p = scanto("\nunixto:",s);
		if (p == NULL)
			p = scanto("\nUNIXTO:",s);
		if (p == NULL)
			p = scanto("\nUnixto:",s);
		if (p == NULL)
		{
			p = scanto("\nTo:",s);
			while (*p && *p != '\n' && *p != '!')
				p++;
			if (*p != '!')
				p = NULL;
			else
				p++;
		}
		if (p == NULL)
		{
/*
			fprintf(stderr,"Mail from %s: no unixto: field\n",&from[0]);
*/
			p = scanto("\nSubj:",s);
			/*
			** Is subject of the form RE: From name:machine ...
			*/
			if (sscanf(p," RE: From %s",&tostr[0]) != 1)
				strcpy(&tostr[0],administrator);

			if (p == NULL)
			{
				p = scanto("\nFrom:",s);
				while (*p && *p != '\n')
					p++;
			}
		}
		else
		{
			while (*p == ' ') p++;
			i = 0;
			while (*p != '\0' && *p != '\n')
				tostr[i++] = *p++;
			tostr[i] = '\0';
		}
		i = 0;
		while (tostr[i] != '\0')
		{
			if (tostr[i] == ',')
				tostr[i] = ' ';
			i++;
		}
		/*
		 *	Check to see if there is BOTH upper AND lower case
		 *	letters in the to field and if so then don't
		 *	reduce it to lower case. Or in other words if
		 *	all alphas are upper case then convert else
		 *	leave it alone.
		 */
		if (allupper(&tostr[0]) == 1)
			maptolower(&tostr[0]);
		fprintf(tosydfp,"@@mail %s\n",&tostr[0]);
		fprintf(tosydfp,"From %s %s %s %2d %02d:%02d:%02d %4d\n",
			&from[0], &weekday[0], &month[0], day, hour,
			minute, second, year);
		fprintf(tosydfp,"To: %s\n",&tostr[0]);
		fprintf(tosydfp,"Subject: ");
		/* Set p to either start the subject field, or be the start of the message */
		q = scanto("\nSubj:",s);
		if (q != NULL)
		{
			while( *q == ' ' || *q == '\t' ) q++;
			p = q;
		}
		/* Monitor traffic */
		q = scanto("\nSubj:",s);
		while( *q == ' ' || *q == '\t' ) q++;
		fprintf(sneakfp,"From %s to %s Subject:",&from[0],&tostr[0]);
		while (q != (char *) 0 && *q != '\n' && *q != '\0')
		{
			putc(*q++,sneakfp);
		}
	}
	while(*p != '\0')
		putc(*p++,tosydfp);
	if(moreflag == THATSALL)
	{
		if (*(p-1) != '\n')
			putc('\n',tosydfp);
		fprintf(tosydfp,"@@end\n");
		fprintf(sneakfp," [c%d s%d]\n",incount-instart,
			NSEGS(incount-instart));
		doneheader = 0;
		instart = incount;
	}
}

static	char	vmserrmsg[50];

/*  Incoming control characters are translated as follows, so they will not
    upset the VMS MAIL input.  Note that \n is mapped to \r; \t, \v, \f and
    \r to themselves; and everything else to BADCTL.
*/

#define	BADCTL	'?'

static	char	ctlcharmap[32] =
{/*00*/	BADCTL,	BADCTL,	BADCTL, BADCTL, BADCTL, BADCTL, BADCTL, BADCTL,
/*010*/	BADCTL, '\t',	'\r',	'\v',	'\f',	'\r',	BADCTL,	BADCTL,
/*020*/	BADCTL,	BADCTL,	BADCTL, BADCTL, BADCTL, BADCTL, BADCTL, BADCTL,
/*030*/	BADCTL,	BADCTL,	BADCTL, BADCTL, BADCTL, BADCTL, BADCTL, BADCTL };

static	int	sm_subj_put;	/* whether we have seen subject yet or not */

smail()
{
	/* print the text of the mail message on netfd */

	int	done;
	int	count;
	char	*p;
	char	linebuf[512];

	done = 0;

	while (!done && !feof(fromsydfp))
	{
		fgets(linebuf,sizeof(linebuf),fromsydfp);
		if (!sm_subj_put &&
		    scanto("Subject:",linebuf) == &linebuf[strlen("Subject:")])
		{
			/* temporarily strip \n off end of subject */
			char *lp, last;
			lp = &linebuf[strlen(linebuf)-1];
			last = *lp;
			if( last == '\n' )
				*lp = '\0';
			fprintf(sneakfp,"%s",linebuf);
			*lp = last;
			sm_subj_put = 1;
		}
		if (!strcmp(linebuf,"@@end\n"))
		{
			done = 1;
		}
		else
		{
			/* Map control characters */
			for(p= &linebuf[0]; *p != '\0'; p++)
				if(*p < '\040')
					*p = ctlcharmap[ (int)(*p) ];
			count = strlen(linebuf);
			if (count >= 150)
			{
				/* eek, this line is too long for vms */
				fprintf(logfp,"\n<---- Line too long ---->\n");
				fprintf(stderr,"Line %d chars long in sent mail\n",count);
				p = &linebuf[0];
				while(count > 0)
				{
					writesync(p,count < 128 ? count : 128);
					writesync("\r",1);

#ifdef	SYNCECHO
/*  This call to sync() waits for the line to be echoed by VMS.  If the VMS
    terminal is set /NOECHO, we do not need to sync().   */

					sync();
#endif	SYNCECHO
/*
					suckline(5);
*/
					p += 128;
					count -= 128;
				}
			}
			else
			{
				writesync(linebuf,count);
#ifdef	SYNCECHO
				sync();
#endif	SYNCECHO
			}
		}
	}
	if(!done)
		fprintf(stderr,"Missing @@end line!\n");
}

putmail()
{
	char	person[512];
	char	date[512];
	char	machine[512];
	int	count;
	int	failcount;
	char	*p;
	char	linebuf[512];

	if((fromsydfp = fopen(sendfile,"r")) == NULL)
	{
		perror(sendfile);
		fprintf(stderr,"Can't open SUN-network interface file\n");
		exit(1);
	}

	while(!feof(fromsydfp))
	{
		fgets(linebuf,sizeof(linebuf),fromsydfp); if(feof(fromsydfp))break;
		count = sscanf(linebuf,"@@mail %s",&tostr[0]);
		if (count != 1)
		{
			fprintf(stderr,"Didn't find @@mail!(%s)\n",linebuf);
			strcpy(tostr,administrator);
		}
		fgets(linebuf,sizeof(linebuf),fromsydfp); if(feof(fromsydfp))break;
		count = sscanf(linebuf,"From %s %24c", &person[0], &date[0]);
		date[24] = '\0';
		if (count != 2)
		{
			fprintf(stderr,"Bad from format! (%s)",linebuf);
			strcpy(person,"Unknown");
			strcpy(date, "Unknown date");
			strcpy(machine,"Unknown machine");
		}
		p = &linebuf[25];	/* skip over known junk */
		while (*p && strcmp(p,"netmail from "))
			p++;
		if (*p)
		{
			p += 13;	/* length of netmail from */
			sscanf(p,"%s",&machine[0]);
		}
		sprintf(subjstr,"From %s %s\r",&person[0],&date[0]);
		fprintf(sneakfp,"From %s to %s ",&person[0],&tostr[0]);
		/* The subject is printed in smail */
		sm_subj_put = 0;

		strcat(tostr,"\r");
		failcount = 0;
		novmsuser = 0;
		outstart = outcount;
		while(talk(sendmail,senderror) != SUCCESS)
		{
			if (novmsuser)
			{
			/* Forward mail to administrator on VMS */
			/* first, strip \r off tostr */
				tostr[strlen(tostr)-1] = '\0';
				sprintf(subjstr,
	  "Mail to %s undeliverable\r*** VMS error message was %s ***\r\r",
				  tostr,vmserrmsg);
				sprintf(tostr,"%s\r",&administrator[0]);
				novmsuser = 0;
			}
			else
			{
				fprintf(stderr,
				    "Unexpected error while sending to %s\n",
				    &tostr[0]);
			}
			if (++failcount >= 3)
			{
				fclose(fromsydfp);
				fprintf(sneakfp," [FAILED c%d s%d]\n",
					outcount-outstart,
					NSEGS(outcount-outstart));
				return(FAIL);
			}
			outstart = outcount;
		}
		fprintf(sneakfp," [c%d s%d]\n",outcount-outstart,
			NSEGS(outcount-outstart));
	}
	fclose(fromsydfp);
	return(SUCCESS);
}

getmail()
{
	int stat = SUCCESS;
	/*
	**	Try and get mail until failure
	**	at moment (YUK)
	*/

	if ((tosydfp = fopen(recfile,"w")) == NULL)
	{
		perror(recfile);
		fprintf(stderr,"Can't open SUN-network interface file\n");
		exit(1);
	}
/*
	suckline(15);
*/
	stat = talk(maildir,readerror);	/* Mail off directory summary */
/*
	suckline(10);
*/
	instart = incount;
	while(stat == SUCCESS && novmsmessages == 0 &&
		(stat = talk(readmail,readerror)) == SUCCESS);
	fclose(tosydfp);
	if(novmsmessages)
		stat = SUCCESS;
	return (stat);
}

char *
scanto(pat,s)
register char	* pat;
register char	* s;
{
	register char	* p;

	p = pat;
	while(*s != '\0' && *p != '\0')
	{
		if (*s == *p)
		{
			p++;
			s++;
		}
		else
		{
			if (p == pat)
				s++;
			else
				p = pat;
		}
	}
	if (*p == '\0')
		return(s);
	else
		return((char *) 0);
}

maptolower(s)
register char	* s;
{

	while(*s != '\0')
	{
		if( 'A' <= *s && *s <= 'Z' )
			*s += 'a' - 'A';
		s++;
	}
}

senddir(s,moreflag)
char	*s;
int	moreflag;
{
	char	loginname2[129];
	int	loglen;

	/*
	** Mail the directory off to whoever is in charge
	*/
	if (novmsmessages == 1)
		return;
	if(!doneheader)
	{
		doneheader = 1;
		fprintf(tosydfp,"@@mail %s\n",administrator);
		fprintf(tosydfp,"From acsnet %s",ijtime());
		/* strip \r off loginname */
		strncpy( loginname2, loginname,
			( loglen = strlen(loginname) - 1 ) );
		loginname2[loglen] = '\0';
		fprintf(tosydfp,"Subject: Mail summary for %s\n",loginname2);
	}
	while(*s != '\0')
		putc(*s++,tosydfp);


	if(moreflag == THATSALL)
	{
		doneheader = 0;
		if(*(s-1) != '\n')
			putc('\n',tosydfp);
		fprintf(tosydfp,"@@end\n");
	}
}

recorderrmsg(s)
char	*s;
{
	/* Illegal username or non-existent user */
	novmsuser = 1;
	fprintf(stderr,"VMS error %s for username %s\n",s,tostr);
	strcpy(&vmserrmsg[0],s);
}

nomessages(s)
char	*s;
{
	/* There are no messages left to read */
	novmsmessages = 1;
	fprintf(logfp, "No messages left at VMS - %s\n", s);
}

char	*ctime();
long	time();

char	*ijtime()
{
	long	tim;

	tim = time((long *) 0);
	return(ctime(&tim));
}

/*
 *	If we have the DECNET NODE::user addressing remove the NODE:: part
 */
remove_node_name(s)
register char	* s;
{
	register char	* t;

	if ((t = strchr(s, ':')) != (char *)0)
	{
		if (*++t == ':')
		{
			t++;
			s = strcpy(s, t);
		}
	}
}


/*
 *	If the string is all uppercase then return 1
 *	else 0
 */

allupper(s)
register char	* s;
{
	register int	up;
	register char	ch;

	up = 0;
	while (ch = *s++)
		if (ch >= 'A' && ch <= 'Z')
			up++;
		else
			if ((ch >= 'a' && ch <= 'z') && up)
				return 0;
	return (up ? 1 : 0);
}
