/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)HomeDomain.c	1.6 88/07/07
*/

/*
**	Return true if we belong to "domain".
**	Relies on fact that HomeNode is last node in NodeTable,
**	and route to any of our domains is via us;
**	but also return true for any domain in local hierarchy,
**	depending on "level".
*/

#include	"global.h"
#include	"address.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"



bool
HomeDomain(domain, handler, level)
	char *		domain;
	char **		handler;
	int		level;
{
	register int	hier;
	NodeLink	route;

	Trace4(2, "HomeDomain(%s, %lx, %d)", domain, handler, level);

	if ( !FindDomain(domain, &route) )
		return false;
	
	hier = RT_DOMAIN(route.nl_domind)->de_hierarchy;

	if ( route.nl_link != (NodeCount-1) )
	{
		if ( hier == LINK_N_A || level > hier )
			return false;
	}
	else
		if ( hier != LINK_N_A && (level&~EXCL_HIER) > hier )
			return false;
	
	if ( route.nl_link >= LinkCount && route.nl_spooler != NULLSTR && handler != (char **)0 )
		*handler = route.nl_spooler;

	return true;
}
