/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Hierarchy.c	1.1 87/05/21
*/

/*
**	Return local hierarchy preceded by a separator as Malloc()ed string,
**	or NULLSTR.
*/

#include	"global.h"
#include	"debug.h"
#include	"address.h"
#include	"state.h"

#include	"route.h"


char *
Hierarchy()
{
	register int	i;
	register int	j;
	register char *	cp;
	register int	l;
	register char **hnames;
	register char *	hier;

	if ( RouteBase == NULLSTR )
		if ( !ReadRoute() )
			return NULLSTR;

	if ( LevelCount == 0 )
		return NULLSTR;

	hnames = (char **)Malloc(sizeof(char *) * LevelCount);

	for ( i = LevelCount, j = 0, l = 0 ; --i >= 0 ; j++ )
		l += strlen(hnames[j] = RT_DOMAIN(*RT_LEVEL(j))->de_name);

	hier = cp = Malloc(l + LevelCount + 1);

	for ( i = LevelCount, j = 0 ; --i >= 0 ; j++ )
	{
		*cp++ = DOMAIN_SEP;
		cp = strcpyend(cp, hnames[j]);
	}

	*cp = '\0';

	free((char *)hnames);

	return hier;
}
