/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)sendControl.c	1.6 86/02/27
*/

/*
**	Functions that send control messages.
*/

#include	"global.h"
#include	"command.h"
#include	"debug.h"

#include	"Stream.h"
#include	"driver.h"
#include	"proto.h"



/*
**	Send a Start-Of-Message
*/

void
SendSOM(chan)
	int		chan;
{
	register Str_p	strp = &outStreams[chan];
	register ulong	wait_time;
	register int	size;
	char		Control[1+STREAMIDZ+1+SIZELEN+1+TIMELEN+1];

	Trace5
	(
		 1
		,"SendSOM for channel %d id \"%s\" size %ld wait %lu"
		,chan
		,strp->str_id
		,strp->str_size
		,LastTime - strp->str_time
	);

	strp->str_state = STR_START;

	if ( LastTime < strp->str_time )
		wait_time = 0;	/* Someone screwed the date, ho, hum */
	else
		wait_time = LastTime - strp->str_time;

#	if	SPRF_SIZE != 0
	size = 1 + sprintf
#	else
		(void)sprintf
#	endif
		(
			 Control
			,"%c%s%c%ld%c%lu"
			,SOM
			,strp->str_id
			,NULLCH
			,strp->str_size
			,NULLCH
			,wait_time
		);

#	if	SPRF_SIZE == 0
	size = 1 + strlen(Control);
#	endif	SPRF_SIZE == 0

	qControl(chan, Control, size);
}



/*
**	Send a SOM_ACCEPT
*/

void
SndSOMA(chan)
	int		chan;
{
	register Str_p	strp = &inStreams[chan];
	register int	size;
	char		Control[1+STREAMIDZ+1+SIZELEN+1];

	Trace4(1, "SndSOMA for channel %d id \"%s\" posn %ld", chan, strp->str_id, strp->str_posn);

	Receiving++;

	SetSpeed();

	strp->str_state = STR_ACTIVE;

#	if	SPRF_SIZE != 0
	size = 1 + sprintf
#	else
		(void)sprintf
#	endif
		(
			 Control
			,"%c%s%c%ld"
			,SOM_ACCEPT
			,strp->str_id
			,NULLCH
			,strp->str_posn
		);

#	if	SPRF_SIZE == 0
	size = 1 + strlen(Control);
#	endif	SPRF_SIZE == 0

	qControl(chan, Control, size);
}



/*
**	Send an End-Of-Message
*/

void
SendEOM(chan)
	int		chan;
{
	register Str_p	strp = &outStreams[chan];
	register int	size;
	char		Control[1+STREAMIDZ+1];

	Trace3(1, "SendEOM for channel %d id \"%s\"", chan, strp->str_id);

	strp->str_state = STR_ENDING;

	/*	This is too optimistic
	**	- should realy be done when transmit queue flushes
	**	- so wait for Update to fix.
	**
	**	if ( --Transmitting < 0 )
	**		Transmitting = 0;
	*/

#	if	SPRF_SIZE != 0
	size = 1 + sprintf
#	else
		(void)sprintf
#	endif
		(
			 Control
			,"%c%s"
			,EOM
			,strp->str_id
		);

#	if	SPRF_SIZE == 0
	size = 1 + strlen(Control);
#	endif	SPRF_SIZE == 0

	qControl(chan, Control, size);
}


void
SndEOMA(chan)
	int		chan;
{
	register Str_p	strp = &inStreams[chan];
	register int	size;
	char		Control[1+STREAMIDZ+1];

	Trace3(1, "SndEOMA for channel %d id \"%s\"", chan, strp->str_id);

	strp->str_state = STR_ENDED;

#	if	SPRF_SIZE != 0
	size = 1 + sprintf
#	else
		(void)sprintf
#	endif
		(
			 Control
			,"%c%s"
			,EOM_ACCEPT
			,strp->str_id
		);

#	if	SPRF_SIZE == 0
	size = 1 + strlen(Control);
#	endif	SPRF_SIZE == 0

	qControl(chan, Control, size);
}



/*
**	Send a q-empty indicator.
*/

void
SendMQE(chan)
	int	chan;
{
	char	Control;

	Trace2(1, "SendMQE for channel %d", chan);

	outStreams[chan].str_state = STR_EMPTY;

	Control = MQ_EMPTY;

	qControl(chan, &Control, 1);
}
