/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

/*
**	Shell program for a "once_only" invocation of a net daemon.
**
**	Assumes that login name is that of host to be netted.
**
**	SETUID => ROOT
*/

#ifndef	lint
static char	sccsid[]	= "@(#)shell.c	1.40 88/08/11";
#endif	lint

#define	FILE_CONTROL
#define	TERMIOCTL

#include	"global.h"
#include	"debug.h"

#include	"Passwd.h"
#include	"state.h"

#include	"caller.h"

#if	CSIRONET
#ifndef	_IOCTL_
#include	<sys/ioctl.h>
#endif
#ifdef	MXTIOCMCI
#include	<sys/mxt.h>
#endif

char	StopEchoMsg[]	= "EI\004";
#endif	CSIRONET

#ifndef	DEVARGS
#define	DEVARGS		"devargs"
#endif

#ifdef	NN2SHELL
#ifndef	NN2DAEMON
#define	NN2DAEMON	INSLIB(CNdaemon)
#endif
#endif

bool	Cooked;
char *	CookMsg		= " -C";
int	CookLen		= 3;

char *	Name;
int	Traceflag;

VarArgs	ExecArgs	=
{
	2,
	NNDAEMON,	/* Default node-node daemon name */
	"-BF"		/* Batch mode */
};

typedef struct
{
	char *	shell;
	char *	daemon;
	char *	mesg;
	char *	args;
}
		S_M;

S_M		StartMesgs[] =
{
	{NNSHELL, NNDAEMON, NNSTARTS, "nnshellargs"},
	{CNSHELL, CNDAEMON, CNSTARTS, "cnshellargs"},
	{PNSHELL, PNDAEMON, PNSTARTS, "pnshellargs"},
#	ifdef	NN2SHELL
	{NN2SHELL, NN2DAEMON, START2MSG, "nn2shellargs"},
#	endif
	{NULLSTR, NULLSTR,  NULLSTR}
};

char *		StartMsg;


void		Args();
bool		readargs();

extern char *	ttyname();
extern char *	getlogin();

extern char *	ReadFile();
extern char *	MatchAction();




main(argc, argv)
	int		argc;
	char *		argv[];
{
	register S_M *	sp;
	register char *	cp;
	register int	fd;
	int		stmsglen;
	bool		nogo;
	Passwd		remote;
	char *		node;
	char *		login;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	if ( *Name == '-' )
		Name++;

	for ( sp = StartMesgs ; (cp = sp->shell) != NULLSTR ; sp++ )
	{
		if ( (cp = strrchr(cp, '/')) != NULLSTR )
			cp++;
		else
			cp = sp->shell;

		if ( strcmp(Name, cp) == STREQUAL )
		{
			StartMsg = sp->mesg;;
			ARG(&ExecArgs, 0) = sp->daemon;
			break;
		}
	}

	if ( cp == NULLSTR )
	{
		StartMsg = concat("Unrecognised shell \"", Name, "\"", NULLSTR);
		goto fail;
	}

	if ( (login = getlogin()) == NULLSTR )
	{
		if ( !GetUser(&remote, getuid()) )
			Error("passwd file error \"%s\"", remote.P_error);
		login = remote.P_name;
	}

	if ( (node = ttyname(1)) != NULLSTR )
	{
		(void)chmod(node, 0600);	/* Turn off "write" permission */
		fd = open(node, O_RDWR);	/* Open in read/write mode */
	}
	else
		fd = open("/dev/tty", O_RDWR);

	if ( fd != SYSERROR )
	{
		(void)close(1);
		(void)dup(fd);
		(void)close(fd);
	}

	if ( !readargs(MatchAction, DEVARGS, node) )
		if ( !readargs(ReadFile, sp->args, NULLSTR) )
			(void)readargs(ReadFile, SHELLARGS, NULLSTR);

#	if	SYSTEM > 0
	if ( ulimit(2, ULIMIT) == SYSERROR )
		Syserror("ulimit(%ld)", ULIMIT);
#	endif

#	ifdef	NICEDAEMON
	(void)nice(NICEDAEMON);
#	endif	NICEDAEMON

	(void)setgid(ACSNETGID);
	(void)setuid(ACSNETUID);

	if ( (node = FindAlias(login)) == NULLSTR )
		node = login;

	NEXTARG(&ExecArgs) = node;

#	ifdef	TIOCFLUSH
	(void)ioctl(1, TIOCFLUSH, (struct sgttyb *)0);
#	endif
#	ifdef	TCFLSH
	(void)ioctl(1, TCFLSH, (struct sgttyb *)2);
#	endif

	SetRaw(1, 0, 1, 0, false);	/* To ignore signals and turn off echo */

	(void)write(1, "\r\n", 2);

	if ( DaemonActive(".", false) )
	{
		StartMsg = NOGOMSG;
fail:
		nogo = true;
	}
	else
		nogo = false;

#	if	CSIRONET
#	ifdef	XTIOCISCN
	if ( ioctl(1, XTIOCISCN, 0) != SYSERROR )
#	else
#	ifdef	XTIOC
	if ( ioctl(1, IOCTYPE, 0) == XTIOC)
#	endif	XTIOC
#	endif	XTIOCISCN
	{
#		if	defined(XTIOCMCI)
#		if	V8 == 1
		union { struct sgttyb x; struct xtiocnc y; } c;
		extern int errno;

		c.y.mci1 = 'E'; c.y.mci2 = 'I';	/* Turn off echo */
		(void)ioctl(1, XTIOCMCI, &c);
#		else	V8 == 1
		(void)ioctl(1, XTIOCMCI, 'E' | ('I' << 8));
#		ifdef	XTIOCRAW
		(void)ioctl(1, XTIOCRAW, 0);
		(void)sleep(3);		/* Maybe there are race problems here? */
#		endif	XTIOCRAW
#		endif	V8 == 1
		(void)sleep(3);		/* Maybe there are race problems here? */
#		else	defined(XTIOCMCI)
#		ifdef	XTIOCCOOK
		(void)ioctl(1, XTIOCCOOK, 0);
		(void)sleep(3);		/* Maybe there are race problems here? */
#		endif	XTIOCCOOK
		(void)write(1, StopEchoMsg, sizeof StopEchoMsg - 1);
		(void)sleep(3);		/* Maybe there are race problems here? */
		(void)write(1, StopEchoMsg, sizeof StopEchoMsg - 1);
		(void)sleep(3);		/* Maybe there are race problems here? */
#		ifdef	XTIOCRAW
		(void)ioctl(1, XTIOCRAW, 0);
		(void)sleep(3);		/* Maybe there are race problems here? */
#		endif	XTIOCRAW
#		endif	defined(XTIOCMCI)
#		if	defined(XTIOCISCN) || defined (XTIOC)
		(void)write(1, "CSIRONET ", 9);
#		endif	defined(XTIOCISCN) || defined (XTIOC)
	}
#	endif	CSIRONET

	stmsglen= strlen(StartMsg);
	(void)write(1, StartMsg, stmsglen);
	if ( !nogo && Cooked )
		(void)write(1, CookMsg, CookLen);
	(void)write(1, "\r\n", 2);

	if ( nogo )
	{
		(void)sleep(5);
		exit(0);
	}

	(void)sleep(2);	/* Let other end start up */

	(void)execve(ARG(&ExecArgs, 0), &ARG(&ExecArgs, 0), StripEnv());
	Syserror(ARG(&ExecArgs, 0));
	exit(1);
}



void
finish(error)
	int	error;
{
	exit(error);
}



/*
**	Extract arguments using passed function on passed file,
**	and pass them to Args()
**	looking like program invoked arguments.
*/

bool
readargs(funcp, file, string)
	char *		(*funcp)();
	char *		file;
	char *		string;
{
	register char *	ap;
	VarArgs		va;

	Trace3(1, "readargs(%s, %s)", file, string);

	if ( (ap = (*funcp)(file, string)) == NULLSTR )
		return false;

	FIRSTARG(&va) = Name;

	if ( SplitArg(&va, ap) >= MAXVARARGS )
		Error("Too many arguments in \"%s\"", file);

	Args(NARGS(&va), &ARG(&va, 0));

	free(ap);

	return true;
}



/*
**	Function to process arguments.
*/

void
Args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	register S_M *	sp;

	while ( --argc > 0 )
	{
		Trace2(1, "Args: \"%s\"", argv[1]);

		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'C':
					Cooked = true;
					NEXTARG(&ExecArgs) = --*argv;
					goto break2;

				case 'D':
					ARG(&ExecArgs, 0) = ++*argv;
					for ( sp = StartMesgs ; sp->daemon != NULLSTR ; sp++ )
					{
						if ( strcmp(*argv, sp->daemon) == STREQUAL )
						{
							StartMsg = sp->mesg;;
							break;
						}
					}
					goto break2;

				case 'I':
					StartMsg = ++*argv;
					goto break2;

				case 'T':
					if ( (Traceflag = atoi(&(*argv)[1])) == 0 )
						Traceflag = 1;
				default:
					NEXTARG(&ExecArgs) = --*argv;
					goto break2;
				}
			}
break2:			;
		}
		else
			NEXTARG(&ExecArgs) = *argv;
	}
}
