static char sccsid[] = "@(#)paradyne.c	1.1 (Softway) 86/07/07";
/*
**	patterns and functions to call using paradyne fdx2400 modems
**	(hayes compatible and more)
*/

#include	"global.h"
#include	"caller.h"
#include	<signal.h>

#define TRACE

/*
**	The following PASSWD stuff is imported from "passwd.q"
*/

#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif
#ifndef	CALLTIMES
#define	CALLTIMES	"calltimes"
#endif	CALLTIMES

#define	MAXPHONES	8

extern	int	Traceflag;

char
	*callargs	= NULLSTR,	
	*daemon1	= NNDAEMON,	/* standard daemon */
	*daemon2	= CNDAEMON,	/* first alternate protocol */
	*daemon3	= PNDAEMON,	/* second alternate protocol */
	*hostflg	= "-BF",	/* dialup, don't fork, cooked */
	*host	 	= NULLSTR,	/* connecting from where? */
	*target  	= NULLSTR,	/* connecting to where? */
	*passwd  	= NULLSTR,
	*afterst	= "ATE0M1V1X1Q1B8S0=14",
	*ph_num[MAXPHONES + 1],		/* array of phone number pointers */
	**phoneno	= ph_num,	/* Current phone number to call */
	*device  	= NULLSTR,	/* Which call unit? (cul0) */
	*speed   	= "2400",
	*opentime	= "60",
	*modemtime	= "15",
	*logintime	= "40";		/* MUST be greater then 15 seconds
						(modem carrier detect time) */

struct speeds
{
	char	*sp_speed;
	char	*sp_mtype[3];
}
	speeds[] =
{
	{  "300", { "2", NULLSTR, NULLSTR } },
	{  "600", { NULLSTR, "6", NULLSTR } },
	{ "1200", { "1",     "4",   "10"  } },
	{ "2400", { "8",     "8",    "8"  } }
};
#define	NUMSPEED	(sizeof speeds / sizeof speeds[0])
#define	BELL		0
#define	CCITT		1
#define	CCITTBIS	2
		

int
	modemty	 = CCITTBIS,
	argspeed = 3,	/* speed table we desire */
	lastspd  = 1,	/* what we think modem speed is */
	speedok	 = 0,	/* we know what the modem speed is */
	rclcount = 0,	/* count of resets calls */
	rcount	 = 0,	/* count of resets */
	tcount	 = 0,	/* count of timeouts */
	lcount	 = 0,	/* count of Unix login attempts */
	ecount	 = 0,	/* count of eofs from remote */
	dcount	 = 0;	/* count of dial attempts */

int
	callbusy(),
	callefail(),
	calltfail(),
	eof(),
	gotlogin(),
	gotpasswd(),
	ignoreline(),
	nocarrier(),
	nodialtone(),
	noanswer(),
	nonumber(),
	resetreset(),
	resettimo(),
	resetunit(),
	ringring(),
	start1(),
	start2(),
	start3(),
	timeout();
	tocallunit(),
	tounix1200(),
	tounix2400(),
	tounix600(),
	tounix300(),
	tounix();

struct patlist atreset[] =
{
	{ "OK",    tocallunit },
	{ "RING",  ringring },
	{ "ERROR", resetreset },
	{ TIMEOUT, resettimo },
	{ 0, 0 }
};


struct patlist atcallunit[] =
{
	{ "OK",		  ignoreline },
	{ "CONNECT 1200", tounix1200 },
	{ "CONNECT 2400", tounix2400 },
	{ "CONNECT 600",  tounix600 },
	{ "CONNECT 300",  tounix300 },	/* really want to bother? */
	{ "CONNECT",	  tounix300 },
	{ "BUSY",	  callbusy },
	{ "NO CARRIER",   nocarrier },
	{ "NO DIALTONE",  nodialtone },
	{ "NO ANSWER",	  noanswer },
	{ "NO NUMBER",	  nonumber },
	{ "RING",	  ringring },
	{ "ERROR",	  callefail },
	{ TIMEOUT,	  calltfail },
	{ 0, 0 }
};

struct patlist atunix[] =
{
	{ "[Ii]llegal",	  ignoreline },
	{ "[Ii]ncorrect", ignoreline },
	{ "[Ll]ogin",	  gotlogin },
	{ "[Pp]assword",  gotpasswd },
	{ "NO CARRIER",   nocarrier },
	{ NNSTARTS,	  start1 },
	{ CNSTARTS,	  start2 },	/* alternate protocol */
	{ PNSTARTS,	  start3 },	/* alternate protocol */
	{ TIMEOUT,	  timeout },
	{ EOFSTR,	  eof },
	{ 0, 0 }
};

args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	register char    *callargp = NULLSTR;

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'b':
					modemty = BELL;
					break;
				case 'c':
					if (*++*argv == 'b')
						modemty = CCITTBIS;
					else
						modemty = CCITT;
					break;
				case 'd':
					device = ++*argv;
					goto break2;
				case 'l':
					host = ++*argv;
					goto break2;
				case 's':
					speed = ++*argv;
					for (c = 0; c < NUMSPEED; ++c)
					{
					    if (strcmp(speeds[c].sp_speed, speed) == 0)
					    {
						argspeed = c;
						goto break2;
					    }
					}
					outend("fail bad speed parameter");
					exit(1);
				case 'p':
					if (phoneno != &ph_num[MAXPHONES])
					{
					    *phoneno++ = ++*argv;
					    goto break2;
					}
					outend("fail too many phone numbers");
					exit(1);
				case 'P':
					passwd = ++*argv;
					goto break2;
				case 'a':
					afterst = ++*argv;
					goto break2;
				case 'C':
					callargp = ++*argv;
					goto break2;
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case '3':
					daemon3 = ++*argv;
					goto break2;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					out("fail unexpected flag \"-");
					out(*argv);
					out("\" in ");
					outend(CALLARGS);
					exit(1);
				}
			}
break2:			;
		}
		else if (target != NULLSTR)
		{
			out("fail target already given: \"");
			out(*argv);
			outend("\" unexpected.");
			exit(1);
		}
		else
			target = *argv;
	}
	if (callargp != NULLSTR)
		callargs = concat(SPOOLDIR(/), target, "/", callargp, NULLSTR);
}

setafter()
{
	static int	afdone;

	if (afdone)
		return;

	++afdone;
	outend("after local");
	outend("after flush");
	outend("after sleep 2");
	outend("after write +++");
	outend("after sleep 2");
	out("after speed "); outend(speed);
	outend("after flush");
	outend("after write \r");
	outend("after sleep 1");
	outend("after flush");
	outend("after write ATH0\r");
	outend("after sleep 1");
	outend("after flush");
	out("after write "); out(afterst); outend("\r");
	outend("after sleep 2");
	outend("after flush");
	outend("after close");
}

sighup()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace sighup received");	/**/
#endif	TRACE
	outend("close");
	out("timeout "); outend(opentime);
	out("opendial "); outend(device);
	out("speed "); outend(speed);
	outend("write \r");
	out("timeout "); outend(modemtime);
	outend("local");
	if (++ecount > 5)
		fail("too many hangups");
	outend("read");
	resetunit();
}

sigabort()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace sigterm received - exiting");	/**/
#endif	TRACE
	outend("sleep 2");
	outend("flush");
	flushinput();
	outend("write +++");
	outend("sleep 2");
	outend("flush");
	flushinput();
	fail("sigterm received");
}

void
init(argc, argv)
	int	argc;
	char	*argv[];
{

	args(argc, argv);
	if (target == NULLSTR)
	{
	    outend("fail no target");
	    exit(1);
	}

	if (callargs == NULLSTR)
		callargs = concat(SPOOLDIR(/), target, "/", CALLARGS, NULLSTR);
	(void)readargs(callargs, args);
	phoneno = ph_num;
	if (*phoneno == NULLSTR)
	{
	    outend("fail no phone numbers");
	    exit(1);
	}
	if (speeds[argspeed].sp_mtype[modemty] == NULLSTR)
	{
	    outend("fail bad speed/type combination");
	    exit(1);
	}
	signal(SIGTERM, sigabort);
	signal(SIGHUP, sighup);
#ifdef	TRACE
	if (Traceflag > 2)
		outend("trace opening line");
#endif	TRACE
	out("timeout "); outend(opentime);
	out("opendial "); outend(device);
	outend("local");
	out("speed "); outend(speed);
	out("timeout "); outend(modemtime);
#ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace starting reader");
#endif	TRACE
	outend("read");
	resetunit();
	rclcount = 0;
}

static int	resetstate;

resetunit()
{
#ifdef	TRACE
	if (Traceflag > 2)
		outend("trace resetting modem");
#endif	TRACE
	if (++rclcount > 20)
		fail("call fail - modem reset called 20 times.");
	rcount = 0;
	state(atreset);
	out("speed "); outend(speed);
	outend("flush");
	flushinput();
	outend("write \r");
	outend("sleep 2");
	outend("flush");
	flushinput();
	resetstate = 0;
	out("write ATE1Q0V1X1S15=28HS13=12HB");
	out(speeds[argspeed].sp_mtype[modemty]);
	outend("\r");
	reset();
}

resettimo()
{
#ifdef	TRACE
	if (Traceflag > 2)
		outend("trace issuing another reset comand");
#endif	TRACE
	if (++rcount > 10)
		fail("call fail - 10 modem resets failed.");
	state(atreset);
	if (!speedok)
	{
		lastspd = (lastspd + 1) % NUMSPEED;
		out("speed "); outend(speeds[lastspd].sp_speed);
		outend("sleep 2"); outend("write +++"); outend("sleep 2");
		outend("write \r");
		outend("sleep 2");
		out("write ATB");
		out(speeds[argspeed].sp_mtype[modemty]);
		outend("\r");
		outend("sleep 2");
	}
	out("speed "); outend(speed);
	outend("flush");
	flushinput();
	outend("write \r");
	outend("sleep 2");
	outend("flush");
	flushinput();
	resetstate = 0;
	outend("write ATE1Q0V1X1S15=28HS13=12H\r");
	reset();
}

resetreset()
{
#ifdef	TRACE
	if (Traceflag > 2)
		outend("trace resetting reset comand");
#endif	TRACE
	if (++rcount > 10)
		fail("call fail - 10 modem resets failed.");
	state(atreset);
	outend("flush");
	flushinput();
	resetstate = 0;
	outend("write ATE1Q0V1X1S15=28HS13=12H\r");
	reset();
}

tocallunit()
{
	++speedok;
	if (resetstate == 0)
	{
#ifdef	TRACE
		if (Traceflag > 1 )
			outend("trace reset modem parameters");
#endif	TRACE
		out("write ATE0H0X1V1");
#ifdef	TRACE
		if (Traceflag > 1 )
			out("write M1");
		else
#endif	TRACE
		out("write M0");
		outend("write \r");
		++resetstate;
	}
	else
	{
#ifdef	TRACE
		if (Traceflag > 1 )
			outend("trace resetting timeout");
#endif	TRACE
		outend("close");
		out("opendial "); outend(device);
		outend("local");
		out("speed "); outend(speed);
		out("timeout "); outend(logintime);
#ifdef	TRACE
		if (Traceflag > 1 )
			outend("trace restarting reader");
#endif	TRACE
		outend("read");
#ifdef	TRACE
		if (Traceflag > 1 )
			outend("trace dialing");
#endif	TRACE
		state(atcallunit);
		outend("write \r");
		outend("sleep 2");
		out("write ATD"); out(*phoneno++); outend("\r");
		if (*phoneno == NULLSTR)
		    phoneno = ph_num;
	}
	reset();
}

callbusy()
{
	if (++dcount <= 9)
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - call busy");
#endif	TRACE
		resetunit();
	}
	else
		fail("was busy 10 times");
}

calltfail()
{
#ifdef	TRACE
	if (Traceflag > 2)
		outend("trace waiting");
#endif	TRACE
	if (++dcount > 9)
		fail("timeout 9 times");
	reset();
}

callefail()
{
	if (++dcount <= 9)
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - error");
#endif	TRACE
		resetunit();
	}
	else
		fail("modem error");
}

ignoreline()
{
	reset();
}

nocarrier()
{
	if (++dcount <= 9)
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - no carrier");
#endif	TRACE
		speedok = 0;
		resetunit();
	}
	else
		fail("no carrier");
}

nodialtone()
{
	if (++dcount <= 9)
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - no dialtone");
#endif	TRACE
		resetunit();
	}
	else
		fail("no dialtone");
}

noanswer()
{
	if (++dcount > 9)
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - no answer");
#endif	TRACE
		resetunit();
	}
	else
		fail("no answer");
}

nonumber()
{
	fail("no number");
}

ringring()
{
#ifdef	TRACE
	if (Traceflag > 1)
		outend("trace RING detected - pausing");
#endif	TRACE
	out("write "); out(afterst); outend("\r");
	outend("sleep 2");
	outend("flush");
	outend("close");
	outend("sleep 360");
	speedok = 0;
#ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace re-opening line after RING");
#endif	TRACE
	out("timeout "); outend(opentime);
	out("opendial "); outend(device);
	outend("local");
	out("speed "); outend(speed);
	out("timeout "); outend(modemtime);
#ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace restarting reader");
#endif	TRACE
	outend("read");
	resetunit();
}

tounix1200()
{
	tounix("1200");
}

tounix2400()
{
	tounix("2400");
}

tounix300()
{
	tounix("300");
}

tounix600()
{
	tounix("600");
}

tounix(sp)
char *sp;
{
	tcount = 0;
	lcount = 0;
	dcount = 0;
	if (strcmp(speed, sp) != 0)
	{
		speed = sp;
		out("speed "); outend(speed);
	}
#ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace waiting for login");
#endif	TRACE
	outend("remote");
	outend("sleep 1");
	outend("flush");
	setafter();
	flushinput();	/* toss away junk */
	state(atunix);
	out("write "); out(host); outend("\r");
	reset();
}

gotlogin()
{
#ifdef	TRACE
	if (Traceflag > 2)
		outend("trace got login");
#endif	TRACE
	if ( ++lcount >= 9 )
		fail("too many login attempts");
	out("write "); out(host); outend("\r");
	reset();
}


gotpasswd()
{
#ifdef	TRACE
	if (Traceflag > 2)
		outend("trace got passwd");
#endif	TRACE
	out("write "); out(passwd); outend("\r");
	reset();
}


start1()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon starting");	/**/
#endif	TRACE
	out("succeed "); outend(target);
	exit(0);
}


start2()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon 2 starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon2);
	out("succeed "); outend(target);
	exit(0);
}


start3()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon 3 starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon3);
	out("succeed "); outend(target);
	exit(0);
}


timeout()
{
	if (++tcount >= 9)
	{
		outend("sleep 2"); outend("write +++"); outend("sleep 2");
		outend("write \r");
		outend("sleep 1");
		outend("write ATH0\r");
		outend("sleep 2");
		outend("flush");
		out("write ATE0Q1V1X1B");
		out(speeds[argspeed].sp_mtype[modemty]);
		outend("\r");
		fail("9 timeouts in login");
	}
	outend("write \r");
	reset();
}

eof()
{
	outend("close");
	out("timeout "); outend(opentime);
	out("opendial "); outend(device);
	out("speed "); outend(speed);
	outend("write \r");
	out("timeout "); outend(logintime);
	outend("local");
	if (++ecount > 5)
		fail("too many EOFs");
#ifdef	TRACE
	if (Traceflag)
		outend("trace unexpected eof");	/**/
#endif	TRACE
	outend("read");
	resetunit();
}

fail(s)
register char *s;
{
	outend("write \r");
	out("write "); out(afterst); outend("\r");
	outend("sleep 2");
	outend("flush");
	outend("close");
	out("fail ");
	outend(s);
	exit(1);
}
