/*
**	Written by Doug Kingston, Centrum voor Wiskunde en Informatica, NL
*/

/*
**	Executed by inetd to initiate an ACSnet connection over TCP.
**
**	Remote hostname is determined and verified by reading hostname
**	and password from the network.  /etc/passwd is currently used
**	for convenience only.
**
**	Usage:  acsd daemon flags
*/


#include	"global.h"
#include	"debug.h"
#include	"state.h"
#include	"caller.h"
#include	<stdio.h>
#include	<netdb.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>

char	*rindex();

int	Traceflag;
char	*Name;

char	*Home = "/usr/spool/ACSnet/_lib";
char	*args[32] = { "ENdaemon", "-BF", 0 };

main(argc, argv)
	int	argc;
	char	**argv;
{
	register int i;
	struct	sockaddr_in from;
	int	fromlen = sizeof from;
	struct	hostent *hp;

	dup2(1, 2);
	if (chdir(Home) < 0) {
		perror(Home);
		exit(9);
	}
	if (getpeername (0, &from, &fromlen) < 0) {
		perror(argv[0]);
		exit(9);
	}
	if ((hp = gethostbyaddr(&from.sin_addr, sizeof(struct in_addr),
	    from.sin_family)) == 0) {
		char *msg = "gethostbyaddr failed.\n";
		write(2, msg, strlen(msg));
		exit(8);
	}
#	ifdef	NICEDAEMON
	(void)nice(NICEDAEMON);
#	endif	NICEDAEMON

	(void)setgid(ACSNETGID);
	(void)setuid(ACSNETUID);

	if ( DaemonActive(".", false) ) {
		printf("Daemon is already active, exiting.\n");
		fflush(stdout);
		exit(7);
	}

	if (argc > 1) {
		for (i = 1; i < argc; i++)
			args[i-1] = argv[i];
		args[i] = hp->h_name;
		args[i+1] = (char *)0;
	} else {
		args[2] = hp->h_name;
		args[3] = (char *)0;
	}

	(void)execv(args[0], args);
	Syserror(args[0]);
	exit (6);
}

finish(code)
int	code;
{
	exit(code);
}
