	/*LINTLIBRARY*/

#include	"global.h"
#include	"regdefs.h"

#define SLOP	5

int	__i_size;

#if VARARGS
char *
regcmp(va_alist) 
	va_dcl
{
	register int	c;
	register char	*ep;
	register char	*sp;
	register char	**adx;
	register va_list vp;
	char		*lastep;
	char		*sep;
	int		nbra;
	int		ngrp;
	char		*stack[SSIZE];
	char		*args[NBRA+1];
	char		**esp;

	esp = stack;

	va_start(vp);
	adx = args;
	c = nbra = ngrp = 0;
	while (sp = va_arg(vp, char *)) {
		*adx++ = sp;
		do
			++c;
		while (*sp++);
	}
	*adx = (char *)0;
	va_end(vp);

	adx = args;
#else	/* VARARGS */
/*ARGSUSED*/
char *
regcmp(cs1, cs2, cs3, cs4, cs5, cs6, cs7, cs8, cs9, cs10) 
char *cs1, *cs2, *cs3, *cs4, *cs5, *cs6, *cs7, *cs8, *cs9, *cs10;
{
	register int	c;
	register char	*ep;
	register char	*sp;
	register char	**adx;
	char		*lastep;
	char		*sep;
	int		nbra;
	int		ngrp;
	char		*stack[SSIZE];
	char		**esp;
	extern char	*malloc();
	extern void	free();

	esp = stack;

	adx = &cs1;
	c = nbra = ngrp = 0;
	while (sp = *adx++)
		do
			++c;
		while (*sp++);
	adx = &cs1;
#endif	/* VARARGS */
	sp = *adx++;
	if ((ep = malloc((unsigned)(2*c + SLOP))) == (char *)0)
		return ep;
	sep = ep;
	if ((c = *sp++) == EOF) goto cerror;
	if (c == '^') {
		c = *sp++;
		*ep++ = CIRCFL;
	}
	if (c == '*' || c == '+' || c == '{')
		goto cerror;
	sp--;
	for (;;) {
		if ((c = *sp++) == EOF) {
			if (*adx) {
				sp = *adx++;
				continue;
			}
			*ep++ = CEOF;
			if (--nbra > NBRA || esp != stack)
				goto cerror;
			__i_size = ep - sep;
			return sep;
		}
		if (c != '*' && c != '{' && c != '+')
			lastep = ep;
		switch (c)
		{
		case '(':
			if (esp == &stack[SSIZE]) goto cerror;
			*esp++ = ep;
			*ep++ = CBRA;
			*ep++ = -1;
			continue;

		case ')':
		    {
			register char	*eptr;
			register int	cclcnt;

			if (esp == stack) goto cerror;
			eptr = *--esp;
			if ((c = *sp++) == '$') {
				if ('0' > (c = *sp++) || c > '9')
					goto cerror;
				*ep++ = CKET;
				*ep++ = *++eptr = nbra++;
				*ep++ = (c-'0');
				continue;
			}
			*ep++ = EGRP;
			*ep++ = ngrp++;
			sp--;
			switch (c)
			{
			case '+':
				*eptr = PGRP;
				break;
			case '*':
				*eptr = SGRP;
				break;
			case '{':
				*eptr = TGRP;
				break;
			default:
				*eptr = GRP;
				continue;
			}
			c = ep - eptr - 2;
			for (cclcnt = 0; c >= 256; cclcnt++)
				c -= 256;
			if (cclcnt > 3) goto cerror;
			*eptr |= cclcnt;
			*++eptr = c;
			continue;
		    }

		case '\\':
			*ep++ = CCHR;
			if ((c = *sp++) == EOF)
				goto cerror;
			*ep++ = c;
			continue;

		case '{':
		    {
			register int i;
			register int cflg;

			*lastep |= RNGE;
			cflg = 0;
		nlim:
			if ((c = *sp++) == '}') goto cerror;
			i = 0;
			do {
				if ('0' <= c && c <= '9')
					i = (i*10+(c-'0'));
				else goto cerror;
			} while (((c = *sp++) != '}') && (c != ','));
			if (i > 255) goto cerror;
			*ep++ = i;
			if (c == ',') {
				if (cflg++) goto cerror;
				if ((c = *sp++) == '}') {
					*ep++ = -1;
					continue;
				}
				else {
					sp--;
					goto nlim;
				}
			}
			if (!cflg) *ep++ = i;
			else if ((ep[-1]&0377) < (ep[-2]&0377)) goto cerror;
			continue;
		    }
		case '.':
			*ep++ = CDOT;
			continue;

		case '+':
			if (*lastep == CBRA || *lastep == CKET)
				goto cerror;
			*lastep |= PLUS;
			continue;

		case '*':
			if (*lastep == CBRA || *lastep == CKET)
			goto cerror;
			*lastep |= STAR;
			continue;

		case '$':
			if (*sp != EOF || *adx)
				goto defchar;
			*ep++ = CDOL;
			continue;

		case '[':
		    {
			register int	cclcnt;

			if ((c = *sp++) == '^') {
				c = *sp++;
				*ep++ = NCCL;
			}
			else
				*ep++ = CCL;
			*ep++ = 0;
			cclcnt = 1;
			do {
				if (c == EOF)
					goto cerror;
				if (c == '-' && cclcnt > 1 && *sp != ']') {
					c = ep[-1];
					ep[-1] = MINUS;
				}
				*ep++ = c;
				cclcnt++;
			} while ((c = *sp++) != ']');
			lastep[1] = cclcnt;
			continue;
		    }

		defchar:
		default:
			*ep++ = CCHR;
			*ep++ = c;
		}
	}
   cerror:
	free(sep);
	return (char *)0;
}
