/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)crc.c	1.21 89/01/13
*/

/*
**	Packet check bytes calculation
**
**	CRC16:  x**16 + x**15 + x**2 + 1
*/

#ifndef	AS
#include	"global.h"
#endif	AS

/*
**	If your BELL_68K C compiler uses 16 bit ints,
**	then you should define INT16BIT.
**
**	There is a test program in Admin/test-crc.c to aid you
**	in developing your own assembler version.
**
**	If your "vax" is a microvax, it does not have a crc instuction
**	CONFIG in your Makefile or run file should include -Duvax
*/

#ifdef	uvax
#undef	vax
#endif

#ifdef	vax

#ifndef	AS

/*
**	Vax "crc" instruction look-up table for polynomial = 0120001
*/

long	crc16t[] =
{
	       0, 0146001, 0154001,  012000, 0170001,  036000,  024000, 0162001
	,0120001,  066000,  074000, 0132001,  050000, 0116001, 0104001,  042000
};

/*ARGSUSED*/
bool
crc(s, n)
	char *	s;
	int	n;
{
	asm("	crc	_crc16t,$0,8(ap),*4(ap)	");
	asm("	cmpw	r0,(r3)			");
	asm("	beqlu	OK			");
	asm("	movw	r0,(r3)			");
	asm("	movl	$1,r0			");
	asm("	ret				");
	asm("OK:movw	r0,(r3)			");
	return false;
}

/*ARGSUSED*/
Crc_t
acrc(c, s, n)
	Crc_t	c;
	char *	s;
	int	n;
{
	asm("	crc	_crc16t,4(ap),12(ap),*8(ap)	");
	asm("	ret					");
#	ifdef	lint
	return c;
#	endif
}

#else	AS

	.text
	.align	1
	.globl	null
null:	.word	0
	ret

#endif	AS

#endif	vax

#if	!defined(vax) && !defined(AS)

Crc_t	crc16t_[256] =
{
	       0, 0140301, 0140601,    0500, 0141401,   01700,   01200, 0141101
	,0143001,   03300,   03600, 0143501,   02400, 0142701, 0142201,   02100
	,0146001,   06300,   06600, 0146501,   07400, 0147701, 0147201,   07100
	,  05000, 0145301, 0145601,   05500, 0144401,   04700,   04200, 0144101
	,0154001,  014300,  014600, 0154501,  015400, 0155701, 0155201,  015100
	, 017000, 0157301, 0157601,  017500, 0156401,  016700,  016200, 0156101
	, 012000, 0152301, 0152601,  012500, 0153401,  013700,  013200, 0153101
	,0151001,  011300,  011600, 0151501,  010400, 0150701, 0150201,  010100
	,0170001,  030300,  030600, 0170501,  031400, 0171701, 0171201,  031100
	, 033000, 0173301, 0173601,  033500, 0172401,  032700,  032200, 0172101
	, 036000, 0176301, 0176601,  036500, 0177401,  037700,  037200, 0177101
	,0175001,  035300,  035600, 0175501,  034400, 0174701, 0174201,  034100
	, 024000, 0164301, 0164601,  024500, 0165401,  025700,  025200, 0165101
	,0167001,  027300,  027600, 0167501,  026400, 0166701, 0166201,  026100
	,0162001,  022300,  022600, 0162501,  023400, 0163701, 0163201,  023100
	, 021000, 0161301, 0161601,  021500, 0160401,  020700,  020200, 0160101
	,0120001,  060300,  060600, 0120501,  061400, 0121701, 0121201,  061100
	, 063000, 0123301, 0123601,  063500, 0122401,  062700,  062200, 0122101
	, 066000, 0126301, 0126601,  066500, 0127401,  067700,  067200, 0127101
	,0125001,  065300,  065600, 0125501,  064400, 0124701, 0124201,  064100
	, 074000, 0134301, 0134601,  074500, 0135401,  075700,  075200, 0135101
	,0137001,  077300,  077600, 0137501,  076400, 0136701, 0136201,  076100
	,0132001,  072300,  072600, 0132501,  073400, 0133701, 0133201,  073100
	, 071000, 0131301, 0131601,  071500, 0130401,  070700,  070200, 0130101
	, 050000, 0110301, 0110601,  050500, 0111401,  051700,  051200, 0111101
	,0113001,  053300,  053600, 0113501,  052400, 0112701, 0112201,  052100
	,0116001,  056300,  056600, 0116501,  057400, 0117701, 0117201,  057100
	, 055000, 0115301, 0115601,  055500, 0114401,  054700,  054200, 0114101
	,0104001,  044300,  044600, 0104501,  045400, 0105701, 0105201,  045100
	, 047000, 0107301, 0107601,  047500, 0106401,  046700,  046200, 0106101
	, 042000, 0102301, 0102601,  042500, 0103401,  043700,  043200, 0103101
	,0101001,  041300,  041600, 0101501,  040400, 0100701, 0100201,  040100
};
#endif	Table

#if	defined(pdp11) && defined(AS)
/*
**	bool crc(string, length)
**	char *string;
*/
	.globl	_crc16t_
	.globl	_crc
_crc:
	len=r0
	crc=r1
	str=r2
	byt=r3

	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	6(sp),str
	mov	8.(sp),len
	clr	crc
1:
	movb	(str)+,byt
	xor	crc,byt
	bic	$177400,byt
	asl	byt
	mov	_crc16t_(byt),byt
	clrb	crc
	swab	crc
	xor	byt,crc
	sob	len,1b

	cmpb	crc,*str
	jeq	1f
	inc	len
1:
	movb	crc,(str)+
	swab	crc
	cmpb	crc,*str
	jeq	1f
	inc	len
1:
	movb	crc,(str)+
	mov	(sp)+,r3
	mov	(sp)+,r2
	rts	pc
/*
**	Crc_t acrc(crc, string, length)
**	Crc_t crc;
**	char *string;
*/
	.globl	_acrc
_acrc:
	crc=r0
	len=r1
	str=r2
	byt=r3

	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	6(sp),crc
	mov	8.(sp),str
	mov	10.(sp),len
1:
	movb	(str)+,byt
	xor	crc,byt
	bic	$177400,byt
	asl	byt
	mov	_crc16t_(byt),byt
	clrb	crc
	swab	crc
	xor	byt,crc
	sob	len,1b

	mov	(sp)+,r3
	mov	(sp)+,r2
	rts	pc
#endif	defined(pdp11) && defined(AS)

#if	(defined(mc68000) || defined(m68k)) && defined(AS)

#if	defined(BELL_68K) || defined(AUX_68K)
/*
**	Bell 68K assembler for PCC2
*/

/*
**	bool crc(string, length)
**	char *string;
*/
	text
	set	crcF,0
#	define	len	%d0
#	define	crc1	%d1
#	define	crc2	%d2
#	define	str	%a0
#	define	tbl	%a1
	global	crc16t_
	global	crc
crc:
	link	%fp,&crcF
	mov.l	%d2,-(%sp)
	mov.l	&0,crc1		/* most assemblers produce movq */
	mov.l	crc1,crc2
	mov.l	8(%fp),str
#ifdef	INT16BIT
	mov.w	12(%fp),len
#else	INT16BIT
	mov.w	14(%fp),len
#endif	INT16BIT
	ble	crc%140
	lea	crc16t_,tbl
	lsr.w	&1,len
	bcc	crc%130

	mov.b	(str)+,crc1
	add.w	crc1,crc1
	mov.w	0(tbl,crc1.w),crc1
crc%130:
	sub.w	&1,len
	bmi	crc%140
crc%170:
	mov.b	(str)+,crc2
	eor.b	crc1,crc2
	add.w	crc2,crc2
	mov.w	0(tbl,crc2.w),crc2
	lsr.w	&8,crc1
	eor.w	crc1,crc2

	mov.b	(str)+,crc1
	eor.b	crc2,crc1
	add.w	crc1,crc1
	mov.w	0(tbl,crc1.w),crc1
	lsr.w	&8,crc2
	eor.w	crc2,crc1
	dbra	len,crc%170
crc%140:
#ifdef	AUX_68K
	mov.l	&0,%d0
#else	AUX_68K
	movq.l	&0,%d0
#endif	AUX_68K
	cmp.b	crc1,(str)
	beq	crc%180
#ifdef	AUX_68K
	mov.l	&1,%d0
#else	AUX_68K
	movq.l	&1,%d0
#endif	AUX_68K
crc%180:
	mov.b	crc1,(str)+
	lsr.w	&8,crc1
	cmp.b	crc1,(str)
	beq	crc%190
#ifdef	AUX_68K
	mov.l	&1,%d0
#else	AUX_68K
	movq.l	&1,%d0
#endif	AUX_68K
crc%190:
	mov.b	crc1,(str)
	mov.l	(%sp)+,%d2
	unlk	%fp
	rts
#	undef	len
#	undef	crc1
#	undef	crc2
#	undef	str
#	undef	tbl


/*
**	Crc_t acrc(crc, string, length)
**	Crc_t crc;
**	char *string;
*/
	text
	set	crcF,0
#	define	crc1	%d0
#	define	crc2	%d1
#	define	len	%d2
#	define	str	%a0
#	define	tbl	%a1
	global	crc16t_
	global	acrc
acrc:
	link	%fp,&crcF
	mov.l	%d2,-(%sp)
	mov.l	&0,crc1		/* most assemblers produce movq */
	mov.l	crc1,crc2
	mov.w	10(%fp),crc1
	mov.l	12(%fp),str
#ifdef	INT16BIT
	mov.w	16(%fp),len
#else	INT16BIT
	mov.w	18(%fp),len
#endif	INT16BIT
	ble	crc%240
	lea	crc16t_,tbl
	lsr.w	&1,len
	bcc	crc%230

	exg.l	crc1,crc2
	mov.b	(str)+,crc1
	eor.b	crc2,crc1
	add.w	crc1,crc1
	mov.w	0(tbl,crc1.w),crc1
	lsr.w	&8,crc2
	eor.w	crc2,crc1
crc%230:
	sub.w	&1,len
	bmi	crc%240
crc%270:
	mov.b	(str)+,crc2
	eor.b	crc1,crc2
	add.w	crc2,crc2
	mov.w	0(tbl,crc2.w),crc2
	lsr.w	&8,crc1
	eor.w	crc1,crc2

	mov.b	(str)+,crc1
	eor.b	crc2,crc1
	add.w	crc1,crc1
	mov.w	0(tbl,crc1.w),crc1
	lsr.w	&8,crc2
	eor.w	crc2,crc1
	dbra	len,crc%270
crc%240:
	mov.l	(%sp)+,%d2
	unlk	%fp
	rts
#	undef	crc1
#	undef	crc2
#	undef	len
#	undef	str
#	undef	tbl
#endif	BELL_68K || AUX_68K

#ifdef	SUN_68K
/*
**
**	MIT assembler version
*/
	.text
	.globl	_crc16t_
/*
**	bool crc(string, length)
**	char *string;
*/
	.globl	_crc

	LF13 = 0
#	define	len	d0
#	define	crc1	d1
#	define	crc2	d2
#	define	str	a0
#	define	tbl	a1

_crc:
	link	a6,#LF13
	movl	d2,sp@-
	movl	a6@(8),str
	movl	#0,crc1		/* should assemble as movq */
	movl	crc1,crc2
	movw	a6@(14),len
	jle	L15
	lea	_crc16t_,tbl
	lsrw	#1,len
	jcc	L13
	movb	str@+,crc1
	addw	crc1,crc1
	movw	tbl@(0,crc1:W),crc1
L13:
	subqw	#1,len
	jmi	L15
L18:
	movb	str@+,crc2
	eorb	crc1,crc2
	addw	crc2,crc2
	movw	tbl@(0,crc2:W),crc2
	lsrw	#8,crc1
	eorw	crc1,crc2

	movb	str@+,crc1
	eorb	crc2,crc1
	addw	crc1,crc1
	movw	tbl@(0,crc1:W),crc1
	lsrw	#8,crc2
	eorw	crc2,crc1
	dbra	len,L18

L15:
	movl	#0,len
	cmpb	str@,crc1
	jeq	L19
	movl	#1,len
L19:
	movb	crc1,str@+
	lsrw	#8,crc1
	cmpb	str@,crc1
	jeq	L20
	movl	#1,len
L20:
	movb	crc1,str@
	movl	sp@+,d2
	unlk	a6
	rts
#	undef	len
#	undef	crc1
#	undef	crc2
#	undef	str
#	undef	tbl


/*
**	Crc_t acrc(crc, string, length)
**	Crc_t crc;
**	char *string;
*/
	.globl	_acrc

	LF22 = 0
#	define	crc1	d0
#	define	crc2	d1
#	define	len	d2
#	define	str	a0
#	define	tbl	a1

_acrc:
	link	a6,#LF22
	movl	d2,sp@-
	movl	#0,crc1		/* should assemble as movq */
	movl	crc1,crc2
	movw	a6@(10),crc1
	movl	a6@(12),str
	movw	a6@(18),len
	jle	L24
	lea	_crc16t_,tbl
	lsrw	#1,len
	jcc	L26

	exg	crc1,crc2
	movb	str@+,crc1
	eorb	crc2,crc1
	addw	crc1,crc1
	movw	tbl@(0,crc1:W),crc1
	lsrw	#8,crc2
	eorw	crc2,crc1
L26:
	subqw	#1,len
	bmi	L24
L27:
	movb	str@+,crc2
	eorb	crc1,crc2
	addw	crc2,crc2
	movw	tbl@(0,crc2:W),crc2
	lsrw	#8,crc1
	eorw	crc1,crc2

	movb	str@+,crc1
	eorb	crc2,crc1
	addw	crc1,crc1
	movw	tbl@(0,crc1:W),crc1
	lsrw	#8,crc2
	eorw	crc2,crc1
	dbra	len,L27
L24:
	movl	sp@+,d2
	unlk	a6
	rts
#	undef	crc1
#	undef	crc2
#	undef	len
#	undef	str
#	undef	tbl

#endif	SUN_68K

#ifdef	WICAT_68K
/*
**	Adapted by David Wilson & David Henderson 11/11/88
**	Wicat assembler version
*/
	.procss	m68000
	.enable	ex
	.config	"68000 1"
	.disabl	us
	.module
	.sect	text
/*
**	bool crc(string, length)
**	char *string;
*/
	.global	_crc

/*	LF13 = 0 */
#	define	len	d0
#	define	crc1	d1
#	define	crc2	d2
#	define	str	a0
#	define	tbl	a1

_crc:
	link	a6,#0		/* LF13 */
	move.l	d2,-(sp)
	move.l	8(a6),str
	move.l	#0,crc1		/* should assemble as movq */
	move.l	crc1,crc2
	move.w	14(a6),len
	ble	L15
	lea	_crc16t_,tbl
	lsr.w	#1,len
	bcc	L13
	move.b	(str)+,crc1
	add.w	crc1,crc1
	move.w	0(tbl,crc1:w),crc1
L13:
	subq.w	#1,len
	bmi	L15
L18:
	move.b	(str)+,crc2
	eor.b	crc1,crc2
	add.w	crc2,crc2
	move.w	0(tbl,crc2:w),crc2
	lsr.w	#8,crc1
	eor.w	crc1,crc2

	move.b	(str)+,crc1
	eor.b	crc2,crc1
	add.w	crc1,crc1
	move.w	0(tbl,crc1:w),crc1
	lsr.w	#8,crc2
	eor.w	crc2,crc1
	dbra	len,L18

L15:
	move.l	#0,len
	cmp.b	(str),crc1
	beq	L19
	move.l	#1,len
L19:
	move.b	crc1,(str)+
	lsr.w	#8,crc1
	cmp.b	(str),crc1
	beq	L20
	move.l	#1,len
L20:
	move.b	crc1,(str)
	move.l	(sp)+,d2
	unlk	a6
	rts
#	undef	len
#	undef	crc1
#	undef	crc2
#	undef	str
#	undef	tbl


/*
**	Crc_t acrc(crc, string, length)
**	Crc_t crc;
**	char *string;
*/
	.global	_acrc

/*	LF22 = 0 */
#	define	crc1	d0
#	define	crc2	d1
#	define	len	d2
#	define	str	a0
#	define	tbl	a1

_acrc:
	link	a6,#0		/* LF22 */
	move.l	d2,-(sp)
	move.l	#0,crc1		/* should assemble as movq */
	move.l	crc1,crc2
	move.w	10(a6),crc1
	move.l	12(a6),str
	move.w	18(a6),len
	ble	L24
	lea	_crc16t_,tbl
	lsr.w	#1,len
	bcc	L26

	exg	crc1,crc2
	move.b	(str)+,crc1
	eor.b	crc2,crc1
	add.w	crc1,crc1
	move.w	0(tbl,crc1:w),crc1
	lsr.w	#8,crc2
	eor.w	crc2,crc1
L26:
	subq.w	#1,len
	bmi	L24
L27:
	move.b	(str)+,crc2
	eor.b	crc1,crc2
	add.w	crc2,crc2
	move.w	0(tbl,crc2:w),crc2
	lsr.w	#8,crc1
	eor.w	crc1,crc2

	move.b	(str)+,crc1
	eor.b	crc2,crc1
	add.w	crc1,crc1
	move.w	0(tbl,crc1:w),crc1
	lsr.w	#8,crc2
	eor.w	crc2,crc1
	dbra	len,L27
L24:
	move.l	(sp)+,d2
	unlk	a6
	rts
	.end
#	undef	crc1
#	undef	crc2
#	undef	len
#	undef	str
#	undef	tbl

#endif	WICAT_68K

#endif	(defined(mc68000) || defined(m68k)) && defined(AS)

#if	defined(ns32000) && defined(AS) && defined(sequent)

/*
**	bool crc(string,length)
**	char	*string;
*/

#define	str	r7
#define	byt	r6
#define	crc	r1
#define	len	r0

	.text
	.globl	_crc16t_
	.globl	_crc
	.align	2
_crc:
	enter	[r7,r6],0
	movd	8(fp), str
	movd	12(fp), len
	cmpqd	0,	len
	beq	L2
	movqd	0,	crc
L1:
	movb	0(str),	byt
	addqd	1, str
	xorw	crc, byt
	bicd	0xffffff00, byt
	movzwd	_crc16t_[byt:w], byt
	bicb	0x0ff, crc
	rotw	8, crc
	xorw	byt, crc
	acbd	-1, len, L1
L2:
	cmpw	crc, 0(str)
	beq	L3
	movqd	1, len
L3:
	movw	crc, 0(str)
	exit	[r7,r6]
	ret	0

#undef	str
#undef	byt
#undef	crc
#undef	len

/*
**	Crc_t acrc(crc, string, length)
**	Crc_t crc;
**	char *string;
*/

#define	astr	r7
#define	abyt	r6
#define	alen	r1
#define	acrc	r0

	.align	2
	.globl	_acrc
_acrc:
	enter	[r7,r6],0
	movzwd	8(fp), acrc
	movd	12(fp), astr
	movd	16(fp), alen
L5:
	movb	0(astr), abyt
	addqd	1, astr
	xorw	acrc, abyt
	bicd	0xffffff00,abyt
	movzwd	_crc16t_[abyt:w], abyt
	bicb	0xff, acrc
	rotw	8, acrc
	xorw	abyt, acrc
	acbd	-1, alen, L5
	exit	[r7,r6]
	ret	0

#undef	astr
#undef	abyt
#undef	alen
#undef	acrc

#endif defined(ns32000) && defined(AS) && defined(sequent)

#if	defined(AS) && defined(M_XENIX)
	end
#endif

#if	!defined(vax) && !defined(pdp11) && !defined(mc68000) && !defined(m68k) && (!defined(ns32000)|| !defined(sequent)) && !defined(AS)

bool
crc(buffer, nbytes)
	register char *	buffer;
	int		nbytes;
{
	register Crc_t	tcrc = 0;
	register int	i;

	if ( (i = nbytes) > 0 )
	do
		tcrc = crc16t_[(tcrc^(*buffer++))&0xff] ^ ((tcrc>>8)&0xff);
	while
		( --i > 0 );

	i = (int)false;

	if ( LOCRC(tcrc) != BYTE(*buffer) )
		i = (int)true;
	*buffer++ = LOCRC(tcrc);

	if ( HICRC(tcrc) != BYTE(*buffer) )
		i = (int)true;
	*buffer++ = HICRC(tcrc);

	return (bool)i;
}


Crc_t
acrc(tcrc, buffer, nbytes)
	register Crc_t	tcrc;
	register char *	buffer;
	int		nbytes;
{
	register int	i;

	if ( (i = nbytes) > 0 )
	do
		tcrc = crc16t_[(tcrc^(*buffer++))&0xff] ^ ((tcrc>>8)&0xff);
	while
		( --i > 0 );

	return tcrc;
}

#endif	C-version
