/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	@(#)UniqueName.c	1.7 85/07/04
*/

/*
**	Make a unique path name using size of message, current time, and process id.
**	Checks that "name" is at least UNIQUE_NAME_LENGTH characters long.
**	Assumes that "Pid" has only 15 bits of useful info.
*/

#include	"global.h"
#include	"debug.h"
#include	"messagename.h"
#include	"spool.h"

extern int	Pid;

#ifndef	GLBOLT
extern Time_t	ticks();
#endif


static int	next_char	= 8;



char *
UniqueName(name, size, t)
	char *		name;
	long		size;
	Time_t		t;
{
	register char *	p;
	register int	i;

	/*
	**	Find last element of path name
	*/

	if ( (p = strrchr(name, '/')) == NULLSTR )
		p = name;
	else
		p++;

	DODEBUG
	(
		if ( strlen(p) < UNIQUE_NAME_LENGTH )
			Fatal("UniqueName last component too short: \"%s\"", name);
	);

	/*
	**	Set first char to reflect message size.
	*/

	if ( size > 0 )
	{
		if ( size < SMALL_MESSAGE )
			*p = SMALL_ID;
		else
		if ( size < MEDIUM_MESSAGE )
			*p = MEDIUM_ID;
		else
			*p = LARGE_ID;
	}

	/*
	**	Find end of name.
	*/

	while ( *p++ );
	p--;

	/*
	**	Last char reflects current HZ.
	*/

	*--p = ValidChars[ticks() & VC_MASK];

	/*
	**	Next 3 chars reflect "Pid".
	*/

	EncodNum(p-=3, (ulong)Pid, 3);

	/*
	**	"Pid" is only 15 bits,
	**	so remember position of deficient char in 'p'.
	**
	**	Next 6 chars reflect "t".
	*/

	EncodNum(p-6, (ulong)(t + size/16), 6);	/* + ~ 1 minute per 1000 bytes */

	/*
	**	Filename generated shouldn't exist,
	**	but if it does, change marked char.
	*/

	for ( i = 0 ; access(name, 0) != SYSERROR ; i++ )
	{
		if ( i >= (VC_MASK - 8) )
			Fatal1("cannot make UniqueName");

		*p = ValidChars[next_char++];

		if ( next_char > VC_MASK )
			next_char = 8;
	}

	return name;
}
