/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID 88/07/24 @(#)Trace.c	1.4
*/

/*
**	Trace on TraceFd
*/

#define	STDIO

#include	"global.h"


FILE *	TraceFd	= stderr;

#define	Fflush	(void)fflush



#if VARARGS
void
Trace(va_alist)
	va_dcl
{
	int		l;
	char *		s;
	va_list		va;

	va_start(va);
	l = va_arg(va, int);
	s = va_arg(va, char *);
	Fflush(stdout);
	Fflush(stderr);
	(void)fseek(TraceFd, (long)0, 2);
	putc('\t', TraceFd);
	while ( l-- > 1 )
		putc(' ', TraceFd);
	(void)vfprintf(TraceFd, s, va);
	putc('\n', TraceFd);
	Fflush(TraceFd);
	va_end(va);
}
#else
/*VARARGS1*/
void
Trace(l, s, a1, a2, a3, a4, a5, a6)
	int		l;
	char *		s;
	char *		a1;
	char *		a2;
	char *		a3;
	char *		a4;
	char *		a5;
	char *		a6;
{
	Fflush(stdout);
	Fflush(stderr);
	(void)fseek(TraceFd, (long)0, 2);
	putc('\t', TraceFd);
	while ( l-- > 1 )
		putc(' ', TraceFd);
	(void)fprintf(TraceFd, s, a1, a2, a3, a4, a5, a6);
	putc('\n', TraceFd);
	Fflush(TraceFd);
}
#endif
