/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)NodeName.c	1.4 89/11/15
*/

/*
**	Routine to obtain our "HomeNode".
*/

#define	FILE_CONTROL
#define	STAT_CALL

#include	"global.h"
#include	"debug.h"

#if	UNAME == 1

#include	<sys/utsname.h>



char *
NodeName()
{
	register int	n;
	struct utsname	SysNames;
	register char *	result = Malloc((sizeof SysNames.nodename) + 1);
	register char *	cp;

	SysNames.nodename[0] = '\0';

	while ( uname(&SysNames) == SYSERROR )
		Syserror("uname(2)");

	(void)strncpy(result, SysNames.nodename, sizeof SysNames.nodename);
	result[sizeof SysNames.nodename] = '\0';

	if ( (cp = strchr(result, '.')) != NULLSTR )
		*cp = '\0';

	if ( (n = strlen(result)) > NODE_NAME_SIZE || n == 0 )
		Fatal2("nodename too %s", n?"long":"short");

	return result;
}
#endif	UNAME == 1



#if	GETHOST == 1

char *
NodeName()
{
	register int	n;
	register char *	cp;
	static char	nodename[NODE_NAME_SIZE+2];

	(void)strclr(nodename, sizeof nodename);

	if ( gethostname(nodename, sizeof(nodename)) == SYSERROR )
		Syserror("gethostname");

	if ( (cp = strchr(nodename, '.')) != NULLSTR )
		*cp = '\0';

	if ( (n = strlen(nodename)) > NODE_NAME_SIZE || n == 0 )
		Fatal2("nodename too %s", n?"long":"short");

	return nodename;
}
#endif	GETHOST == 1



#if	UNAME != 1 && GETHOST != 1

static char *	NameFile	= NODENAMEFILE;



char *
NodeName()
{
	register char *	nodename;
	register char *	cp;
	register int	n;

	if ( (nodename = ReadFile(NameFile)) == NULLSTR )
		Fatal2("cannot read \"%s\"", NameFile);

	if ( (cp = strchr(nodename, '.')) != NULLSTR )
		*cp = '\0';

	if ( (n = strlen(nodename)) > NODE_NAME_SIZE || n == 0 )
		Fatal2("nodename too %s", n?"long":"short");

	return nodename;
}
#endif	UNAME != 1
