/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)LastNode.c	1.2 86/07/03
*/

/*
**	Extract last destination from route, and pass back its name.
**
**	Returns NULLSTR if route empty.
*/

#include	"global.h"
#include	"debug.h"
#include	"header.h"



char *
LastNode(route)
	char *		route;
{
	register char *	p;
	register char *	e;
	register char *	node;

	Trace2(1, "LastNode(%s)", route);

	if ( (p = route) == NULLSTR )
		return NULLSTR;

	if ( (p = strrchr(p, HC_ROUTE)) == NULLSTR )
		return NULLSTR;

	if ( (e = strchr(++p, HC_TIME)) == NULLSTR )
		Error("Missing time field in message header route: \"%s\"", HdrRoute);
	else
		*e = '\0';

	node = newstr(p);

	*e = HC_TIME;

	Trace2(1, "LastNode found \"%s\"", node);

	return node;
}
