/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ExRoute.c	1.1 84/06/12
*/

/*
**	Extract destinations from route,
**	and pass them back in time/from/to tuples.
**
**	Returns false if error or !*funcp.
*/

#include	"global.h"
#include	"header.h"



bool
ExRoute(cp, funcp)
	register char *	cp;
	bool		(*funcp)();
{
	register char *	cp1;
	register char *	tp;
	register char *	from;
	register ulong	tt;

	if ( *cp++ != HC_ROUTE )
		return false;

	for ( from = NULLSTR ; ; )
	{
		if ( (cp1 = strchr(cp, HC_ROUTE)) != NULLSTR )
			*cp1 = '\0';

		if ( (tp = strchr(cp, HC_TIME)) == NULLSTR )
		{
			if ( cp1 != NULLSTR )
				*cp1 = HC_ROUTE;
			if ( from != NULLSTR )
				free(from);
			return false;
		}

		*tp = '\0';

		tt = (ulong)atol(tp+1);

		if ( cp1 != NULLSTR )
			*cp1++ = HC_ROUTE;

		if ( from != NULLSTR )
		{
			if ( !(*funcp)(tt, from, cp) )
			{
				*tp = HC_TIME;
				free(from);
				return false;
			}

			free(from);
		}

		from = newstr(cp);
		*tp = HC_TIME;

		if ( (cp = cp1) == NULLSTR )
			break;
	}

	free(from);

	return true;
}
