/*
**	Copyright (c) 1988 Alan Skea, University of New South Wales
*/

/*
**	Udp socket establishment routines
*/


#ifndef	lint
static char	sccsid[]	= "@(#)ConnectSocket.c	2.0	88/02/25";
#endif	lint

#ifdef	BASSER

#include <sys/types.h>
#include "include/sys/socket.h"
#include "include/sys/uio.h"
#include "include/netinet/in.h"
#include "include/netdb.h"
#include <signal.h>
#include <setjmp.h>

#undef	BSIZE

#else	BASSER

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <setjmp.h>

#endif	BASSER

#ifndef SYSERROR
#define SYSERROR	(-1)
#endif

#define	BSIZE	256

extern unsigned int	TimeOut;

#ifdef	BASSER
char *	Rem_Server	= "acssasha";
char *	Loc_Server	= "acsbasser";
char *	Proto	= "udp";
#else	BASSER
char *	Server	= "acsnet";
char *	Proto	= "udp";
#endif	BASSER
jmp_buf	cur_env;

time_out()
{
	longjmp(cur_env, 1);
}


static
unsigned short
swb(s)
unsigned short	s;
{
	return ((s >> 8) & 0xFF) | ((s << 8) & 0xFF00);
}

int
ConnectSocket(Udp_Target)
	char *			Udp_Target;
{

#ifdef	BASSER

	struct servent *	serv;
	int			loc_port;
	int			rem_port;
	struct hostent *	host;
	char			buf[BSIZE];
	int			s;

	gethostname(buf, BSIZE);

	if ((host = gethostbyname(buf)) == (struct hostent *)0)
	{
		Error("could not find my inet address");
		return SYSERROR;
	}

	if ((serv = getservbyname(Loc_Server, Proto)) == (struct servent *)0)
	{
		Error("Service \"%s/%s\" not available", Loc_Server, Proto);
		return SYSERROR;
	}

	loc_port = serv->s_port;

	if ((serv = getservbyname(Rem_Server, Proto)) == (struct servent *)0)
	{
		Error("Service \"%s/%s\" not available", Rem_Server, Proto);
		return SYSERROR;
	}

	rem_port = serv->s_port;

	if ((host = gethostbyname(Udp_Target)) == (struct hostent *)0)
	{
		Error("%s: no such internet host", Udp_Target);
		return SYSERROR;
	}

	if ((s = udp_connect(swb(loc_port), *(int *)(host->h_addr), swb(rem_port))) == -1)
	{
		Syserror("could not udp_connect to remote");
		return SYSERROR;
	}

	return s;

#else	BASSER
	struct servent *	serv;
	struct hostent *	host;
	struct sockaddr_in	my_sock;
	struct sockaddr_in	dest;
	struct iovec		miov;
	struct msghdr		mhdr;
	char			buf[BSIZE];
	int			my_sock_len;
	int			s;

	gethostname(buf, BSIZE);

	if ((host = gethostbyname(buf)) == (struct hostent *)0)
	{
		Error("could not find my inet address");
		return SYSERROR;
	}

	bzero((char *)&my_sock, sizeof(my_sock));
	bcopy(host->h_addr, (char *)&my_sock.sin_addr, host->h_length);
	my_sock.sin_family = AF_INET;
	my_sock.sin_port = 0;

	if ((serv = getservbyname(Server, Proto)) == (struct servent *)0)
	{
		Error("Service \"%s/%s\" not available", Server, Proto);
		return SYSERROR;
	}

	if ((host = gethostbyname(Udp_Target)) == (struct hostent *)0)
	{
		Error("%s: no such internet host", Udp_Target);
		return SYSERROR;
	}


	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
	{
		Syserror("could not make a socket");
		return SYSERROR;
	}

	if (bind(s, &my_sock, sizeof(my_sock)) == -1)
	{
		Syserror("could not bind name to socket");
		return SYSERROR;
	}

	my_sock_len = sizeof(my_sock);

	if (getsockname(s, &my_sock, &my_sock_len) == -1)
	{
		Error("could not get socket name");
		return SYSERROR;
	}

	my_sock.sin_family = htons(my_sock.sin_family);

	bzero((char *)&dest, sizeof(dest));
	dest.sin_family = AF_INET;
	dest.sin_port = serv->s_port;
	bcopy(host->h_addr, (char *)&dest.sin_addr, host->h_length);

	if (sendto(s, &my_sock, sizeof(my_sock), 0, &dest, sizeof(dest)) == -1)
	{
		Syserror("error sending to %s", Server);
		return SYSERROR;
	}

	miov.iov_base = (char *)&dest;
	miov.iov_len = sizeof(dest);
	mhdr.msg_name = (caddr_t)0;
	mhdr.msg_namelen = 0;
	mhdr.msg_iov = &miov;
	mhdr.msg_iovlen = 1;
	mhdr.msg_accrights = (caddr_t)0;
	mhdr.msg_accrightslen = 0;

	if (setjmp(cur_env))
	{
		Error("No response from %s", Udp_Target);
		return SYSERROR;
	}
	else
	{
		signal(SIGALRM, time_out);
		alarm(TimeOut);

		if (recvmsg(s, &mhdr, 0) == -1)
		{
			alarm(0);
			Syserror("receiving from %s", Udp_Target);
			return SYSERROR;
		}

		alarm(0);
		dest.sin_family = ntohs(dest.sin_family);

		if (connect(s, &dest, sizeof(dest)) == -1)
		{
			Syserror("could not connect to private socket");
			return SYSERROR;
		}

		return s;
	}
#endif	BASSER
}
