#ifndef lint
static char hrcsid[]="$Header: proof.h,v 5.0 87/03/24 14:19:18 solomon Stab $";
#endif lint
/*
 *
 * The following stuff is an attempt to save time redrawing by saving
 * stuff in a fairly low-level form.
 * To save space, we save things as a stream of shorts, each made up
 * of a 4-bit opcode and a 12-bit operand.
 *
 * Note on context:
 * When a character is output, it is done so in a context consisting of
 * a vertical and horizontal position, a font position, and a pointsize.
 * (Actually, the latter two are summarized in the fontset structure
 * pointed to by fs.  Each time the font number or size is changed,
 * fs is updated, possibly requiring a new 'font' (font + size) file
 * to be opened).
 * 
 * A 'p' (new page) command implicitly resets the horizontal and vertical
 * positions to zero.  Moreover, it seems that ditroff is careful to
 * start each page with commands to set the absolute horizontal and
 * vertical positions (H and V), the pointsize (s) and the font number (f).
 * Thus we need only record changes to hpos, vpos, font, and size inside
 * a page.  However, the .fp request changes the binding of font number to
 * font name, and this info is NOT repeated for each page.  Hence this
 * program cannot currently deal with .fp requests.  On the other hand,
 * (1) dealing properly with .fp requests would immensely complicate the
 * feature of being able to skip to a particular page, and (2) since all
 * available fonts are "mounted" at the start of the file, there's
 * really no reason why anybody should want to use .fp.  (I suspect it's
 * only included for compatibility with the old C/A/T troff.)
 * 
 * Note: all positions and distances are expressed in pixels (proof device
 * resolution) to avoid having to scale values more than once.  Each
 * operator that changes the "current position" contains the new (absolute)
 * position in its operands, to avoid accumulation of round-off error.
 * If this program is ever ported to a device with more than 4096
 * pixels in either direction, some things will have to change.
 */

#define PAGEMAX 20000 /* max number of operations per page */
#define OPERATOR 0xf000
#define OPERAND 0x0fff
#define OPCHAR  0x0000  /* a character to display */
#define OPHPOS  0x1000  /* absolute horiz position in pixels */
#define OPVPOS  0x2000  /* absolute vertical postion in pixels (top of char) */
#define OPFONT  0x3000  /* font number */
#define OPSIZE  0x4000  /* font size */
#define OPLINE	0x5000	/* line: next two shorts contain new x,y position */
#define	OPCIRC	0x6000	/* circle: operand is new horiz position */
#define OPELLIP	0x7000	/* elipse: next two shorts contain newx, height */
#define OPARC	0x8000	/* arc: following four shorts are offset to center
                         * (dx,dy) and coordinates of end of arc (newx,newy)
                         */
#define OPWIG	0x9000	/* curve or polygon:
                         * Operand is 0 for spline, >0 for "pic curve",
                         * and <0 for polygon.  Points follow in x,y pairs
                         * (absolute coordinates), terminated by -1.
                         */
#define OPTHICK	0xa000	/* line thickness */
#define	OPSTYLE	0xb000	/* line style */
short op_space[PAGEMAX];
short *op_next;
short *op_last;
#define SAVE(c) { *op_next++ = (c); \
	if (op_next>op_last) error(FATAL,"Page buffer overflow"); }

Window window;

int	hpos;		/* current horizontal position (left = 0) */
int	vpos;		/* current vertical position (down positive) */

int Thickness;	/* current line thickness (in pixels) */
int Style;		/* current line style (solid, dashed, etc) */

/* "colors" */
int Foreground;
int Background;
/* function for drawing (GXor for black-on-white, GXand for white-on-black) */
int Overstrike;

#define  abs(n)		((n) >= 0 ? (n) : -(n))
#define  hmot(n)	hpos += n
#define  hgoto(n)	hpos = n
#define  vmot(n)	vpos += n
#define  vgoto(n)	vpos = n

#define	FATAL	1
