.TH XNWM 1 "19 July 1985" "X Version 10"
.SH NAME
xnwm - X window system manager process
.SH SYNOPSIS
.B xnwm
[ -cmsnftv2 ] [ @\fIborder\fP ] [ %\fIiconDelta\fP ]
.br
	[ fm=\fIfont\fP ] [ fi=\fIfont\fP ] [ fs=\fIfont\fP ]
.br
	[ l=\fIop\fP ] [ m=\fIop\fP ] [ r=\fIop\fP ]
.br
	[ \fIhost\fP:\fIdisplay\fP ] [ =\fIgeometry\fP ]
.SH DESCRIPTION
.PP
The window manager is a process that allows the user of a display running the
X window system to manipulate the windows on the screen.  X implements the
`desktop model' of overlapping windows;
.I xnwm
allows windows to be moved, iconified, and resized, allows the order of the
windows in the `stack' of overlapping windows to be manipulated, and allows
the keyboard focus to be attached to a window.  X allows windows to contain
other windows, but
.I xnwm
only manipulates the top-level windows and not any of the subwindows.
.PP
.I Xnwm
takes arguments
.I host
and
.I display,
which refer the the host and display number.
For example `xnwm amadeus:1' would start up the window manager
on display one on the machine amadeus.
By default,
.I xnwm
uses the host and display number stored in
the environment variable DISPLAY, and therefore they are not normally
specified.
.PP
.I Xnwm
has 2 modes of operation, `normal' and `popup',  In normal mode
.I xnwm
creates a menu window across the top of the screen.  To perform an
action, you click any mouse button in the appropriate menu box and then click
the same button in the window you wish to affect.
.I Xnwm
also reserves certain button/key
combinations and interprets them as operations on existing windows.
The key combination is specified in the command line with some subset of
the options:
.B -c
(Control),
.B -m
(Meta), and
.B -s
(Shift).  For example, if you specify the options
.B -cm
then the Control and Meta keys must be down at the time a mouse button is
depressed.
The option
.B -n
(None) means that no buttons need be held down.  This is discouraged
since it means that applications will never receive unshifted mouse
clicks.
If no combination is specified in the command line, Meta is assumed.
Note:  the key combination is not necessary when using functions from the
menu; it is only needed with the assigned button functions to distinguish
window manager operations from operations destined for the application
running within the window.
.PP
The window manager normally takes control of the screen at various
times to assure that the screen image remains correct while performing
window manager operations.  When this happens, requests from other
applications are temporarily suspended until the window manager
finishes the operation.  The option
.B -f
(no freeze) disables this.  If this option is specified, window
outlines for
.I Move
and
.I Resize
will flicker rather than remaining solid, and the background behind
popup windows (see later) will take longer to redraw.
.PP
The options
.B -t
(thin), 
.B -v
(vertical), and
.B -2
(2 rows) control the format of the menu bar.  In the absence of any of
these, the menu extends across the entire screen.  If the
.B -t
option is given, the menu bar will not extend fully across the screen;
instead there will be room at the right (convenient for, for example, a clock
window).  If the
.B -v
option is used, the menu windows are stacked vertically instead of spread
horizontally.  The
.B -2
option causes the menu windows to be in two rows, allowing room for a
terminal window the height of the screen while still allowing menu access.
Either of the last two options automatically selects the
.B -t
option.  The menu is located in the upper left corner of the screen by
default, but its location can be set with the
.B =\fIgeometry\fP
option as usual with X applications.  (Notice that there is no size
component, position information is used only.)
.PP
.I Xnwm
will use reverse video for the menu, the cursor, icon text, and the
frame around selected windows if the
.B -r
(reverse) option is used.
.PP
The border width around selected windows can be changed with the
.B @
argument; the default is 5 pixels.
.PP
The default font for displaying text is ``8x13''.  You can specify a different
font with the
.B fm=
(Menu font),
.B fi=
(Icon font), and the
.B fs=
(Size window font) options.
.PP
Initially, the left, middle, and right mouse buttons are bound to the
operations
.I Select, Raise,
and
.I Move.
You can change these bindings with
the
.B l=
(left),
.B m=
(middle), and
.B r=
(right) arguments.  Each should be followed by one of the letters "srmilzc",
representing, respectively,
.I Select, Raise, Move, Iconify, Lower, resiZe,
and
.I Circulate.
They may also be followed by nothing, in which case no function
is bound to that key.
.PP
Clicking any button that is not bound to the
.I Select
function in the background will cause the menu window to become
visible if it has become covered by other windows.  Double clicking the
background will cause the menu to move back to its original position.
.PP
In popup mode, the menu window is not normally displayed, but instead `pops
up' when a particular button is pressed.  To get popup mode, bind the letter
``p'' to any of the three buttons as described above.  (You may also bind the
other buttons as desired.)  Whenever the bound button is clicked while the
appropriate combination of control, meta, and shift keys is depressed, or
any time a button that is not bound to the
.I Select
function is clicked in the background, the menu will appear beneath
the cursor.  You may then select any menu function you wish; after the
operation is completed the menu will disappear.  To make the menu disappear
without performing any operation, just move the cursor out of the menu area.
Note:  the mouse button bound to the popup function may not be rebound using
.B Assign.
Using popup mode with complicated screen images and with no freeze (the
.B -f
option) may cause some difficulties
if the menu obscures the image, since the applications will have to redraw
their windows after the menu goes away.
.PP
The available commands are described below.  For any of these
commands, if you press a button to start a command, and then want to abort
the command, simply press one of the other buttons before releasing the
first button.
.PP
.B Select
attaches the keyboard to a window, i.e., keyboard input will go
to that window (hierarchy) even when the mouse is outside the window.
It also
.B Raises
the selected window.  Selecting the background will detach the keyboard from
any window (actually, it attaches it to the background window).  If no window
is selected the keyboard input will go to the window which currently contains
the mouse cursor.  The selected window is highlighted by drawing a partial
frame around the window.  Selecting an icon allows the icon name to be
edited: the delete key deletes the last character, control-U deletes the
entire name, and other characters are appended to the current name.  Typing a
return restores the input focus to the most recent non-icon window selected.
.PP
.B Raise
raises the window to the top of any stack of overlapping windows.
.PP
.B Move
is used to move a window.
If you apply it to a window, an outline will be moved with
the mouse; when you release the button, the window will be moved.
.PP
.B (De)Iconify
will make a window into an icon.  If the mouse is moved more than a threshold
amount, or this is the first time the window has been iconified, the icon will
appear at the location on the screen where the button is released.  Otherwise,
the icon will reappear at its previous location.  This threshold may be
changed with the
%\fIiconDelta\fP
option.  Giving a negative value will disable this effect.  The default is 5
pixels.
.B (De)Iconify
will make the original window reappear at its former position on the screen
if it is applied to an icon.  The name displayed in the icon can be edited by
.B Selecting
the icon.
.PP
.B Lower
will `push' the window you point at to the bottom of any
stack of overlapping windows.
.PP
.B Resize
is used to resize a window by moving a corner or an edge.
If you apply it to a window, a rubber banded outline of the window will be
displayed and moving the mouse will change its size, leaving the opposite
corner or other edges fixed.  The corner or edge to be moved depends on the
where the mouse is when the button is pressed.  Imagine the window divided
with grid of nine rectangles.  If the mouse is in one of the four corner
rectangles or the center rectangle, then the corner closest to the mouse
will be moved; otherwise, the closest edge will be moved.  When the button
is released, the window will be resized.
.PP
.B Circulate
causes the lowest window in the stack of overlapping windows to be
.B Raised
; successive applications will reveal every window in turn.
.PP
.B Assign
allows you to change the button bindings; to use it click any button in the
Assign menu window and then click the same button in any other function to
assign that function to that button.  To remove the assignment from a button,
double click the
.B Assign
window.
.SH X DEFAULTS AND OPTION SUMMARY
.TP 8
.B MenuFont (fm=\fIname\fP)
Set the default font for the menu.
.TP 8
.B SizeFont (fs=\fIname\fP)
Set the default font for the size window.
.TP 8
.B IconFont (fi=\fIname\fP)
Set the default font for icons.
.\" The @ causes problems in a .TP, so the next one is done out by hand
.PP
.B FrameWidth (@\fIvalue\fP)
.RS 8
Set the width of the frame around selected windows.
.RE
.TP 8
.B IconifyDelta (%\fIvalue\fP)
Set the threshold for moving icons.
.TP 8
.B ReverseVideo (-r)
Sets reverse video for the menu, icons, selection border, and cursor.
.TP 8
.B MenuFormat (-tv2)
Sets the format of the menu; should be some subset of
.B tv2
meaning thin, vertical, or 2 rows.
.TP 8
.B Freeze (-f)
If set to ``off'', disables
.I xnwm
taking control of the screen during operations.
.TP 8
.B KeyCombination (-csmln)
Sets the keys required to specify 
.I xnwm
operations; should be some subset of
.B csmln
meaning control, shift, meta, lock, and none.
.TP 8
.B LeftButton (l=value)
Sets the default left button function; should be one of
.B srmilzcp
.TP 8
.B MiddleButton (m=value)
Sets the default middle button function; should be one of
.B srmilzcp
.TP 8
.B RightButton (r=value)
Sets the default right button function; should be one of
.B srmilzcp
.TP 8
.B Geometry (={+-}xoff{+-}yoff)
Sets the location of the menu.
.SH FILES
.nf
.ta \w'/usr/athena/lib/vs/font        'u
/usr/new/lib/X/font		directory of fonts
.fi
.SH ENVIRONMENT
DISPLAY	- to get default host and display number
.SH "SEE ALSO"
X(8C)
.SH AUTHOR
Paul Asente, Stanford University, using some algorithms originally by
Bob Scheifler, MIT Laboratory for Computer Science
