#include <HFS.h>
#include "sys_param.h"
#include "tests.h"

extern int trace;

struct {
	char	dir[33];
	} dirs[100];

extract_path(path)
char *path;
{
	ioParam	pb;			/* my parameter block for PB's	*/
	int dcount = 0;
	int vrefnum;
	CInfoPBRec iopb;
	int result;
	long dirid;
	int i;
	WDPBRec gv_iopb;
	char root[33];
	
	extern int default_vrefnum;

	/* get basic info */
	gv_iopb.ioNamePtr = (StringPtr)root;
	result = PBHGetVol(&gv_iopb, FALSE);

    dirid = gv_iopb.ioWDDirID;
	PtoCstr(root);

	if (trace)
		printf("\t[extract_path] vol name '%s', working dirid 0x%lx\n", root, dirid);

	/* pop back up following parent id's */
	while (dirid != 2)
		{
		iopb.hFileInfo.ioVRefNum = default_vrefnum;
		iopb.hFileInfo.ioFDirIndex = -1;
		iopb.hFileInfo.ioDirID = dirid;
		dirs[dcount].dir[0] = '\0';
		iopb.hFileInfo.ioNamePtr = (StringPtr)dirs[dcount].dir;
		result = PBGetCatInfo(&iopb, FALSE);

		PtoCstr(dirs[dcount].dir);
		dirid = iopb.dirInfo.ioDrParID;

		if (trace)
			printf("\t[extract_path] dir '%s', dirid 0x%lx\n",
				dirs[dcount].dir, iopb.dirInfo.ioDrDirID);

		dcount++;
		}

	
	/* build ascii path name */
	path[0] = '\0';
	strcat(path, root);
	strcat(path, ":");

	if (trace) printf("\t[extract_path] root '%s'\n", path);

	for (i = dcount-1; i >= 0; i--)
		{
		if (strlen(dirs[i].dir) > 0)
			{
			strcat(path, dirs[i].dir);
			if (i > 0)
				strcat(path, ":");

			if (trace) 
				printf("\t[extract_path] adding '%s' to make '%s'\n",
					   dirs[i].dir, path);
			}
		}

	return 1;
}

int rmdir_recurse(dir)
char *dir;
{
	char str[MAXPATHLEN], path[MAXPATHLEN];
	long dirid;
	CInfoPBRec iopb;
	int result;
	
	extern StringPtr pnamecpy();
	extern long default_dir_id;
	extern int default_vrefnum;

	if (trace)
		printf("\t[rmdir_recurse] '%s'\n", dir);

#ifdef SYSTEM
	sprintf(str, "rm -r %s", dir);
	return system(str);
#else
	
	/* close default wd #2 */
	{
	WDPBRec cw_iopb;
	
	cw_iopb.ioVRefNum = 0x8013;
	result = PBCloseWD(&cw_iopb, FALSE);
    }

	/* reset default dir */
	{
	WDPBRec cd_iopb;
	
	cd_iopb.ioNamePtr = (StringPtr)0;
	cd_iopb.ioVRefNum = default_vrefnum;
	cd_iopb.ioWDDirID = 2;
	result = PBHSetVol(&cd_iopb, FALSE);

	if (result != noErr)
		merror(result, "rmdir_recurse - PBHSetVol", path);
    }

	unix_to_mac_path(str, dir, TRUE);
	
	/* use name to get dir's dir id */
	iopb.hFileInfo.ioNamePtr = pnamecpy(path, str);
	iopb.hFileInfo.ioVRefNum = default_vrefnum;
	iopb.hFileInfo.ioDirID = default_dir_id;
	
	iopb.hFileInfo.ioFDirIndex = 0;
	result = PBGetCatInfo(&iopb, FALSE);
	
	/* delete the dir's contents recursively */
	rm_recurse_dir(iopb.dirInfo.ioDrDirID);

	/* then, delete the dir */
	PtoCstr((char *)iopb.hFileInfo.ioNamePtr);

	/* place us in parent of dir to delete */
	chdir(iopb.hFileInfo.ioNamePtr);
	chdir("..");

	remove_id(2L, iopb.hFileInfo.ioNamePtr);

#endif

	if (trace)
		printf("\t[rmdir_recurse] done.\n");

	return 0;
}

rm_recurse_dir(dirid)
long dirid;
{
	CInfoPBRec iopb;
	int result;
	char name[33];
	int index;
	
	extern int default_vrefnum;

	if (trace) printf("\t[rm_recurse_dir] dirid 0x%lx\n", dirid);

	/* re-scan dir until it's empty */
	for (index = 1; TRUE;)
		{
		iopb.hFileInfo.ioVRefNum = default_vrefnum;
		iopb.hFileInfo.ioFDirIndex = index;
		iopb.hFileInfo.ioDirID = dirid;
		name[0] = '\0';
		iopb.hFileInfo.ioNamePtr = (StringPtr)name;
		result = PBGetCatInfo(&iopb, FALSE);
	
		if (trace) printf("index %d, PBGetCatInfo result %d\n", index, result);

		if (result != noErr)
			return result;

		PtoCstr(name);

#define ReturnIfError(expr)		if ((result = (expr)) != noErr) return result;

		/* delete if not dir */
		if (iopb.hFileInfo.ioFlAttrib & 0x10)
			{
			if (trace)
				printf("\tdir '%s' (id 0x%lx)...\n",
					   name, iopb.dirInfo.ioDrDirID);
			
			rm_recurse_dir(iopb.dirInfo.ioDrDirID);

			ReturnIfError( remove_id(dirid, name) );
			}
		else
			{
			if (trace) printf("\tfile '%s'...\n", name);

			ReturnIfError( remove_id(dirid, name) );
			}
		}

if (trace) printf("\n\n");
	return noErr;
}

remove_id(dirid, name)
long dirid;
char *name;
{
	HFileParam pb;
	int result;
	
	extern int default_vrefnum;

	CtoPstr(name);
	pb.ioNamePtr	= (StringPtr)name;
	pb.ioVRefNum	= default_vrefnum;
	pb.ioDirID		= dirid;
	pb.ioFVersNum	= 0;
	
	result = PBHDelete(&pb, FALSE);

	PtoCstr(name);
	if (trace || result != noErr)
		printf("\t[remove_id] failed: dirid 0x%lx, name '%s', result %d\n",
				dirid, name, result);

	return result;
}

askfordir(path, pVrefnum)
char *path;
int *pVrefnum;
{
	Point point;
	SFReply reply;
	char name[256];
	
	point.h =
	point.v = 40;

	strcpy(name, "\pTestFile");
	
	SFPutFile(point, "\pTest directory", name, (ProcPtr)0, &reply);
	
	if (!reply.good)
		return FALSE;
	
	/* set default vol and dir */
	{
	WDPBRec cd_iopb;
	int result;

	cd_iopb.ioNamePtr = (StringPtr)0;
	cd_iopb.ioVRefNum = reply.vRefNum;
	cd_iopb.ioWDDirID = 2;
	result = PBHSetVol(&cd_iopb, FALSE);

	if (result != noErr)
		merror(result, "askfordir - PBHSetVol", path);
    }

	/* generate base path */
	{
	WDPBRec gv_iopb;
	int result;

	/* get basic info */
	gv_iopb.ioNamePtr = (StringPtr)path;
	result = PBHGetVol(&gv_iopb, FALSE);
	PtoCstr(path);

	*pVrefnum = gv_iopb.ioVRefNum;
	}

	/* set default vol and dir */
	{
	WDPBRec cd_iopb;
	int result;

	cd_iopb.ioNamePtr = (StringPtr)0;
	cd_iopb.ioVRefNum = *pVrefnum;
	cd_iopb.ioWDDirID = 2;
	result = PBHSetVol(&cd_iopb, FALSE);

	if (result != noErr)
		merror(result, "askfordir - PBHSetVol", path);
    }

if (0)
	strcat(path, "/cayman");

	if (trace)
		printf("\t[askfordir] vrefnum %d, path '%s'\n", *pVrefnum, path);
	return TRUE;
}

