/*	@(#)negseek.c	1.1 88/10/12 NFS Rev 2 Testsuite	*/
/*
 * test seek to negative offset
 */

#include <tests.h>

#ifdef ANSI
void main(int argc, char *argv[]);
#endif

void
main(argc, argv)
	int argc;
	char *argv[];
{
	int fd;
	long i;
	char buf[8192];
	extern int errno;

	if (argc != 2) {
		fprintf(stderr, "usage: negseek filename\n");
		exit(1);
	}
	fd = open(argv[1], O_CREAT|O_RDONLY, CHMOD_YES);
	if (fd < 0) {
		perror(argv[1]);
		exit(1);
	}

	for ( i = 0L; i>-10240L ;i -= 1024L ) {
		if (lseek(fd, i, SEEK_SET) < 0) {
			perror("lseek");
			exit(1);
		}
		if (read(fd, buf, sizeof buf) < 0) {
			perror("read");
			exit(0);
		}
	}
	unlink(argv[1]);
	exit(0);
}
