#
# PICASSO (HP300)
#
machine		"hp300"
cpu		"HP320"
cpu		"HP330"
cpu		"HP340"
cpu		"HP350"
cpu		"HP360"
cpu		"HP370"
cpu		"HP375"
cpu		"HP380"
ident		VANGOGH

timezone	8 dst
maxusers	48

# Standard options
options		QUOTA
options		INET
options		FFS,MFS,NFS,FIFO
options		"COMPAT_43"

# Options for all HP machines
options		SYSVSHM
options		HPUXCOMPAT

# Options specific to this host.
options		DEBUG,DIAGNOSTIC
options		PANICBUTTON
options		KTRACE
options		"BUFPAGES=900"
options		"NKMEMCLUSTERS=1024"
options		"HILVID=1"
options		"PRF_INTERVAL=500"
options		KGDB,"KGDBRATE=19200"
options		HPFPLIB
options		GATEWAY

config		vmunix root on sd0 swap on sd0d and sd1d and sd2d
config		rdvmunix root on rd0 swap on rd0b and rd1b
config		genvmunix swap generic

master		hpib0	at scode7
master		hpib1	at scode?
master		hpib2	at scode?
disk		rd0	at hpib? slave ?
disk		rd1	at hpib? slave ?
disk		rd2	at hpib? slave ?
disk		rd3	at hpib? slave ?
tape		ct0	at hpib0 slave ?
tape		ct1	at hpib0 slave ?

master		scsi0	at scode?
master		scsi1	at scode?
master		scsi2	at scode?
master		scsi3	at scode?
disk		sd0	at scsi? slave ?
disk		sd1	at scsi? slave ?
disk		sd2	at scsi? slave ?
disk		sd3	at scsi? slave ?
disk		sd4	at scsi? slave ?
disk		sd5	at scsi? slave ?
disk		sd6	at scsi? slave ?
disk		sd7	at scsi? slave ?
disk		sd8	at scsi? slave ?
disk		sd9	at scsi? slave ?
disk		sd10	at scsi? slave ?
disk		sd11	at scsi? slave ?
tape		st0	at scsi? slave ?
tape		st1	at scsi? slave ?

device		le0	at scode?
device		le1	at scode?
device		dca0	at scode9 flags 1
device		dcm0	at scode? flags 0xe
device		dcm1	at scode? flags 0xe
device		dcm2	at scode? flags 0x10
device		dcm3	at scode? flags 0xe
device		dcm4	at scode? flags 0xe
device		dcm5	at scode? flags 0xe
device		dcm6	at scode? flags 0xe

device		grf0	at scode?
device		grf1	at scode?
device		grf2	at scode?

pseudo-device	sl	4
pseudo-device	bpfilter 16
pseudo-device	ite
pseudo-device	pty	64
pseudo-device	loop
pseudo-device	ether

pseudo-device	clock

pseudo-device	swappager
pseudo-device	vnodepager
pseudo-device	devpager
