.TH PEXEC 1P "22 June 1983"
.UC 4
.SH NAME
pexec \- execute command over project hierarchy
.SH SYNOPSIS
.B pexec
[\fB\-?ciqx\fR] [\fB\-P \fRpdirname] [\fB\-T \fRtypexpr] [\fB\-X \fRerrstatus]
command
.SH DESCRIPTION
.I Pexec
descends recursively through a project hierarchy executing
.I command
in each project directory using either the
.I csh
or
.I sh
command interpreter. The directories at each level are traversed in
alphabetical order.
.PP
Before executing
.I command
in each directory, the current working project is reset to the
project in which the directory resides.
.PP
Unless the
.B \-i
option is used,
.I pexec
quits if a directory is inaccessible or
.I command
returns a non-zero exit status. This prevents propagation of errors through
a project.
.PP
Care should be taken when using the characters $ * [ | ( ) and \\ in
the
.I command
as they are also meaningful to the command shell. It is safest to enclose
the entire
.I command
in single quotes.
.PP
If a
.I typexpr
boolean type label expression is specified,
.I pexec
considers only those project directories with type labels that satisfy
that expression.
The order in which the project directories are traversed depends on the
relative priorities of the type labels attached to each directory.
Only those type labels that appear in
.I typexpr
are used. Directories with labels of the same priority are sorted
alphabetically. For example, if the project directories `include', `cmd1',
`cmd2', `lib1', and `lib2' have the following labels:
.PP
.nf
.ta 1.0i 2.5i
	include	print.0, src, update.0, include
	cmd1	print.1, src, update.2, cmdsrc
	cmd2	print.1, src, update.2, cmdsrc
	lib1	print.2, src, update.1, libsrc
	lib2	print.2, src, update.1, libsrc
.DT
.fi
.PP
then type label expression `update' will force
.I pexec
to traverse the directories in the order `include', `lib1', `lib2', `cmd1',
`cmd2'.
.PP
Labels that are part of a negated expression are not used for sorting.
.SH OPTIONS
.IP \fB\-?\fR
Do not print ``Do you really want to quit? [yn](y):'' when interrupted in
foreground mode. Quit immediately.
.IP \fB\-c\fR
Instruct
.I csh
to read the `.cshrc' startup file.
.IP \fB\-i\fR
Ignore inaccessible directories and non-zero exit codes from
.I command.
.IP \fB\-q\fR
Quiet mode. Do not print `==>
.I directory
<==' titles.
.IP \fB\-x\fR
Trace, and print directory titles, but do not execute
.I command.
.IP "\fB\-P \fIpdirname\fR"
Specify a project other than the current working project. If
.I pdirname
is a project directory,
.I command
will be executed only in that directory.
.IP "\fB\-T \fItypexpr\fR"
Only execute
.I command
in project directories corresponding to boolean type label expression,
.I typexpr.
.IP "\fB\-X \fIerrstatus\fR"
If
.I pexec
fails, exit with status
.I errstatus.
Default error status is 1.
.SH EXAMPLES
To list all of the files in a project using
.I ls,
type:
.PP
	pexec ls
.PP
If the directories containing source code have been labeled previously as
type `src', then, to count the total number of lines of source code in a project,
type:
.PP
	pexec  \-Tsrc  \'cat *.h *.c\'  | wc \-l
.PP
where quotes surround the
.I cat
command to prevent file name expansion in the
current directory.
.SH "ENVIRONMENT VARIABLES"
.ta \w'PROJECT'u+.5i
PROJECT	Current working project root directory.
.br
SHELL	Name of command interpreter.
.DT
.SH "SEE ALSO"
csh(1), sh(1)
.SH DIAGNOSTICS
If
.I pexec
is interrupted while executing
.I command
in foreground,
the message, ``Do you really want to quit? [yn](y):'' will appear after
.I command
has completed.
.PP
If the error message, ``pexec: \fIlabel, label \fR...: conflicting type
label priorities'', occurs when performing an operation on a set of
project directories that have been selected according to a boolean
type label expression with more than one type label, this indicates
that the directories cannot be sorted satisfactorily because of a clash
in priorities. For example, if project directories
.I a
and
.I b,
selected by type label expression `print\|&\|update', have
the following type labels:
.PP
		directory a:	print.1, src, update.2
.br
		directory b:	print.2, src, update.1
.PP
the ordering will be
.I ab
if the directories are sorted according to the
`print' type label, and
.I ba
if they are sorted by the `update'
type label. The
.B \-D
debug option can be used to dump the list of project directories that match
.I typexpr,
together with their type labels.
.PP
.I Pexec
returns the exit status of
.I command.
Exit status 0 is normal. Non-zero exit status indicates an error.
.SH AUTHOR
Peter J. Nicklin
.SH BUGS
The PROJECT environment variable must be defined.
.PP
Since
.I pexec
uses a separate command shell to execute
.I command
in each directory, the characters $ * [ | ( ) and \\ will be meaningful
to that shell even if
.I command
is protected by single quotes.
