.TH HELP 1 "28 May 1984"
.SH NAME
help \- an easy way to find and use information
.SH SYNOPSIS
.B help [ \-d
dirlist
.B ] [ \-m
key
.B ] [ \-p
prompt
\fB] [ \-i ] [ \-n ] [ \-q ] [\fP
topic
.B [
subtopic
.B [
subsubtopic
\fB[ ... ] ] ] ]\fP
.SH DESCRIPTION
The primary purpose of
.I help
is to provide easy access to on-line documentation.
In response to the command
.BR help ,
the user is placed in an interactive
setting and presented with a list of topics and a set of instructions
to perform on them.
To bypass the interactive part and just display what is known about
a topic, enter the topic name on the command line after \fBhelp\fP.
.PP
A topic is displayed by typing its name or a unique abbreviation,
and topics may be requested and listed with numbers.
Topics may be saved in a file or printed on the lineprinter.
When you request a topic not on its list,
.I help
can search a set of indexes into its own files,
the Unix Programmer's Manual, and various optional off-line sources.
References found in this way can be displayed if material is available on-line.
All topic requests, including ones which yield no useful information,
are automatically recorded for later analysis by system maintainers.
Any user may effectively add topics to \fBhelp\fP's knowledge base
from that user's point of view by suitably defining the environment
variable HELPPOOL.
Thus each user can have a private cache of topic files accessible with
.IR help .
.PP
In general the purpose of
.I help
is to provide a way to move around easily in a set of
hierarchical databases, namely, one or more Unix file system subtrees.
Although an inherent disadvantage of such databases is that data may be
hidden within the hierarchies, the program
overcomes this to some extent with its indexing feature.
.I Help
can be made to serve in special purpose
applications without programmer intervention.
.PP
The following technical description may be of little interest to casual users.
.PP
The default knowledge base consists of the files and directories in
the subtree /usr/lib/help/cat.
If the environment variable HELPPOOL contains a list of directories
(separated by spaces or colons), their contents are merged with the
default list to form the knowledge base.
The entire directory pool may be overridden by giving a
directory list in
.I dirlist
after the
.B \-d
option.
.PP
The interactive user prompt is by default the tail of argument zero from
.IR exec (3),
usually ``help'', followed by a list of directories leading
to the current subtopic directory.
A different prompt may be specified by making a link with a name of your
choice to /usr/ucb/help or by specifying a name after the
.B \-p
option.
A special prompt is used in help-index mode,
which is entered when the user initiates an index search
on a given keyword.
The string ``-index'' and the keyword are added to the prompt
in this case.
.PP
.I Help
may be invoked with any number of
.IR topic ,
.IR subtopic ,
.IR subsubtopic ,
etc., arguments, which may be abbreviated.
Starting at the top directory level
.I help
tries to change to each directory named by successive arguments,
interactively resolving non-unique abbreviations along the way.
When a name corresponds to a file, the file is displayed and, unless
.B \-i
was specified, the program exits.
If the standard output is not a terminal,
.I help
refuses to be interactive unless the
.B \-i
option is given.
If the last valid name is a directory, or no topics were requested,
.I help
lists the topics at the current level and prompts for user input.
.PP
Maintainers of
.IR help -style
knowledge bases can use the
.B \-m
option to perform various custodial functions using shell scripts.
Permission to use this option is restricted to those users who
have write permission for one of the directories in the list specified
after the
.B \-d
option or in HELPPOOL.
If such a directory exists, it (the first one) becomes the value
of the variable $subtree, and the local maintenance configuration
is sourced from $subtree/../maint/config before most functions are performed.
The function name, given as
.I key
after
.B \-m ,
may be followed by other arguments (but no topic abbreviations
are recognized here), in which case the script
$subtree/../maint/do.\fIkey\fP is invoked.
In the absence of
.IR key ,
the word ``default'' is used, usually causing
the valid function choices to be listed.
.PP
A simple macro package called
.B \-mayday
is used by authors to format
.I help
topic files.
Its purpose is to standardize somewhat the display format for topic files,
create a hook for the index generating script, and
guarantee page headers and footers of a fixed length so that
.I help
will not strip out too much or too little of a topic file
when displaying it without pagination.
The only macro call required is the initializing macro,
.BR .TI ,
followed by a filename and an optional date on the same line,
and by a keyword-rich title (to be useful for the index) on the next line.
A handful of other macros are provided for compatibility with other packages,
though they are usually unnecessary.
.PP
Authors of
.I help
topics may make topic files into shell scripts by entering a # or :
at the beginning of the first line.
This causes help to run the script when that topic is requested,
allowing programs to be demonstrated, questions asked, etc.
There are maintenance scripts which will convert a script with embedded
.I nroff
source text into a script with embedded formatted text, provided
the lines to be formatted appear between the special
lines ``##nroff'' and ``##''.
.PP
Similarly, authors may use programs as topic files, the source
being written in an aribtrary programming language.
.PP
The
.B \-n
option causes topics to be listed and accessible by numbers
(and still accessible by unique abbreviations).
The
.B \-q
option suppresses the instruction line appearing before each prompt,
including the prompt printed by the
.B \-d
option to
.IR more (1),
through which long output is piped after multiple
blank lines in a row are reduced to one.
Both of these features are available as instructions from within
.IR help .
.PP
The internal instructions are described below.
.PP
.TP 10
\fB% \fRor\fB $\fR
Quit from help and return to the shell.
Control-d works also.
.TP 10
topic
Display
.I topic 
on the terminal.
.I Topic
may be the shortest unique name
abbreviating a topic at the current level.
.I Help
prompts for more characters if a non-unique name is given,
and asks to look in the index if the name abbreviates no topic.
If a name is given as = in any context other than index mode,
the current topic is used,
where the current topic is defined to be the one most recently accessed.
In index mode, a name of = has no special significance, and if
.I topic
is a unique abbreviation for a reference, that reference
is displayed.
.TP 10
topic\fB +\fP
Enter index mode and see what more is known about
.I topic
by looking in the indexes.
A missing topic is taken to be =.
.TP 10
topic \fB>\fP file
Save
.I topic
in
.IR file .
A missing topic is taken to be =, and a missing
file is taken to be ``helpsave''.
If
.I file
exists the topic file is appended to it.
.TP 10
topic \fB>&\fP file
Save
.I topic
in
.IR file ,
preserving headers and footers.
Normally, topics are stored as
.IR nroff \'d
text files, the headers and footers of
which are suppressed when displayed on a terminal.
They are preserved in
.I file
with this instruction.
.TP 10
topic \fB|\fP lpr
Print
.I topic
on the lineprinter, preserving headers and footers.
The
.I lpr
string may be replaced with another program name (such as
.I ipr
or
.IR vpr )
followed by one optional argument.
A missing
.I topic
is taken to be the current topic, and a missing
.I lpr
is taken to be ``lpr''.
.TP 10
.B ?
List the internal instructions and describe them briefly.
.TP 10
.B .
List topics at the current level, indicating the current
topic, if any, with an =.
In index mode, list references for the current subject.
.TP 10
.B ..
Back up to and list the next higher level of topics.
From index mode, this means leave index mode and continue
at the previous topic level.
.TP 10
.B /
Back up to and list the top level of topics.
From index mode, this means leave index mode and continue
at the top level of topics.
.TP 10
.B <
Send comments or other input to the maintainer of
.I help
via electronic mail.
.TP 10
.BR ! command
Do a Unix
.I command
and then return to help.
All occurrences of = inside
.I command
will be replaced by the current topic, if any.
.TP 10
\fB\(**\fP flag \fBon\fP/\fBoff\fP
Set
.I flag
.B on
or
.B off
to adjust the behavior of the program.
A missing value for
.I flag
means invert its current value, and \fB\(**\fP by itself
means display the current flags, their settings, and
what they signify.
There are currently two flags,
.B n
and
.BR q ,
which control the same things as the
.B \-n
and
.B \-q
options to
.IR help .
.SH FILES
.nf
/usr/lib/help/cat			root of system \fIhelp\fP files
/usr/lib/help/src			nroff sources for system \fIhelp\fP files
/usr/lib/help/log			log of user requests; can be removed
/usr/lib/help/maint		maintenance scripts
/usr/lib/help/cat/general	general introduction to \fIhelp\fP
/usr/lib/help/cat/index_\(**	used to locate further references
/usr/lib/tmac/tmac.ayday	macro package for \fIhelp\fP files
.fi
.SH SEE\ ALSO
environ(7), exec(3), learn(1), lpr(1), more(1), nroff(1)
.SH AUTHOR
John Kunze
.SH BUGS
Pathnames inside topic names are not recognized.

.I Help
is really just a weak, friendly shell.
Strengthening it might be more painful and less useful
than civilizing the shell.
