%{

/************************************************************************
 *									*
 *			Copyright (c) 1986 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *		         All Rights Reserved.				*
 *									*
 *	Permission to use, copy, modify, and distribute this software	*
 *	and its documentation is hereby granted only to licensees of 	*
 *	The Regents of the University of California pursuant to their	*
 *	license agreement for the Berkeley Software Distribution 	*
 *	provided that the following appears on all copies.		*
 *									*
 *            "LICENSED FROM DIGITAL EQUIPMENT CORPORATION		*
 *                      COPYRIGHT (C) 1986				*	
 *                 DIGITAL EQUIPMENT CORPORATION			*
 *                         MAYNARD, MA					*
 *                     ALL RIGHTS RESERVED.				*
 *									*
 *      THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT	* 
 *	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL	*
 *	EQUIPMENT CORPORATION.  DIGITAL MAKES NO REPRESENTATIONS	*
 *	ABOUT SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS	*
 *	SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.		*
 *									*	
 * 	IF THE UNIVERSITY OF CALIFORNIA OR ITS LICENSEES MODIFY 	*	
 *	THE SOFTWARE IN A MANNER CREATING DERIVATIVE COPYRIGHT 		*	
 *	RIGHTS APPROPRIATE COPYRIGHT LEGENDS MAY BE PLACED ON THE	*
 *	DERIVATIVE WORK IN ADDITION TO THAT SET FORTH ABOVE."		*	
 *									*
 ************************************************************************/
 


/*
 * MODIFICATION HISTORY
 *
 * 000 -- M. Gancarz, DEC Ultrix Engineering Group
 */

#ifndef lint
static char *sccsid = "@(#)lex.l	3.8	1/24/86";
#endif

#include "y.tab.h"
#include "uwm.h"

char *dequote();
char *stash();

%}
W	[ \t]+
%%

#.*\n				{ return(COMMENT); }	/* Comments. */
{W}				{ ; }	/* Whitespace. */
[^ \"\t\n#=\^\!\|\(\)\{\}:;]+	{ yylval.sval=stash(yytext);return(STRING); }
\"[^\"\n]*\"			{ yylval.sval=stash(dequote(yytext));
				  return(STRING); }
\n				{ return(NL); }
.				{ return(*yytext); }

%%

/*
 * Remove the quotes enclosing a quoted string.
 */
char *
dequote(s)
char *s;
{
    char *p;

    ++s;
    p = rindex(s, '"');
    *p = '\0';
    return(s);
}

/*
 * Save string away in memory and return a pointer to it.  If
 * no space could be found, quit with a fatal error.
 */
char *stash(s)
char *s;
{
    char *ptr;
    char *malloc();

    ptr = malloc(strlen(s) + 1);
    if (ptr == NULL) {
        Error("out of space");
    }
    return(strcpy(ptr, s));
}
