/*	@(#)test5b.c	1.2 89/01/10 NFS Rev 2 Testsuite	*/
/*
 * Test read - will read a file of specified size, contents not looked at
 *
 * Uses the following important system calls against the server:
 *
 *	chdir()
 *	mkdir()		(for initial directory creation if not -m)
 *	open()
 *	read()
 *	unlink()
 */

#include "sys_param.h"
#ifndef major
#include "sys_types.h"
#endif
#include "sys_time.h"
#include "sys_stat.h"
#include <stdio.h>
#include "tests.h"

test5b(argc, argv)
	int argc;
	char *argv[];
{
	int count = DCOUNT;	/* times to do each file */
	int ct;
	long size = DSIZE;
	long si;
	int i;
	int fd;
	int bytes;
	char *bigfile = "bigfile";
	struct timeval time;
	char str[MAXPATHLEN];
	struct stat statb;
	char *opts;
	char buf[BUFSZ];

	umask(0);
	setbuf(stdout, NULL);
	Myname = *argv++;
	argc--;
	while (argc && **argv == '-') {
		for (opts = &argv[0][1]; *opts; opts++) {
			switch (*opts) {
				case 'h':	/* help */
					usage();
					exit(1);

				case 't':	/* time */
					Tflag++;
					break;
				
				case 'f':	/* funtionality */
					Fflag++;
					break;
				
				case 'n':	/* No Test Directory create */
					Nflag++;
					break;

				default:
					error("unknown option '%c'", *opts);
					usage();
					exit(1);
			}
		}
		argc--;
		argv++;
	}

	if (argc) {
                size = getparm(*argv, 1, "size");
		argv++;
		argc--;
	}
	if (argc) {
                count = getparm(*argv, 1, "count");
		argv++;
		argc--;
	}
	if (argc) {
                bigfile = *argv;
		argv++;
		argc--;
	}
	if (argc) {
		usage();
		exit(1);
	}
	
	if (Fflag) {
		Tflag = 0;
		count = 1;
	}

	fprintf(stdout, "%s: read\n", Myname);

	mtestdir(NULL);

	if (Tflag) {
		starttime();
	}

	for (ct = 0; ct < count; ct++) {
		if ((fd = open(bigfile, 0)) < 0) {
			error("can't open '%s'", bigfile);
			exit(1);
		}
		for (si = size; si; si -= BUFSZ) {
			bytes = MIN(BUFSZ, si);
			if (read(fd, buf, bytes) != bytes) {
				error("'%s' read failed", bigfile);
				exit(1);
			}
		}
		close(fd);
	}

	if (Tflag) {
		endtime(&time);
	}
	fprintf(stdout, "\tread %ld byte file %d times", size, count);
	if (Tflag) {
		fprintf(stdout, " in %ld.%-2ld seconds (%ld bytes/sec)",
		    time.tv_sec, time.tv_usec / 10000, size*count/time.tv_sec);
	}
	fprintf(stdout, "\n");

	if (unlink(bigfile) < 0) {
		error("can't unlink '%s'", bigfile);
		exit(1);
	}
	complete();
}
