.TH UMODEM 1
.SH NAME
umodem - Version 3.1 -- UNIX-Based Remote File Transfer Facility
.SH SYNOPSIS

.nf
Usage:  
        umodem -[c!rb!rt!sb!st][options] filename

Major Commands --
        c  <-- Enter Command Mode
        rb <-- Receive Binary
        rt <-- Receive Text
        sb <-- Send Binary
        st <-- Send Text
Options --
        1  <-- (one) Employ TERM II FTP 1
        4  <-- Enable TERM FTP 4
        7  <-- Enable 7-bit transfer mask
        a  <-- Turn ON ARPA Net Flag
        d  <-- Do not delete umodem.log file before starting
        l  <-- (ell) Turn OFF LOG File Entries
        m  <-- Allow file overwiting on receive
        p  <-- Turn ON Parameter Display
        y  <-- Display file status (size) information only

.SH DESCRIPTION
.fi
Umodem uses the Christensen protocol to transfer files to
and from CP/M systems.

Umodem -- Implements the "CP/M User's Group XMODEM" protocol, the
TERM II File Transfer Protocol (FTP) Number 1, and the TERM II
File Transfer Protocol Number 4 for packetized file
up/downloading.

There is currently no batch transfer capability.  The program
writes logging data to a file in the user's home directory
called umodem.log.

The program will do a protocol file transfer with error checking
to or from a CP/M system running Ward Christensen's program MODEM
or one of its derivatives (MODEM7 or APMOD777 etc.) or any
program that uses the same protocols (e.g. ZPRO, TERM II).  Note that
executable and squeezed files must use the -sb or -rb options.

Umodem supports an interactive mode in which the user may perform
a number of Umodem-oriented functions without leaving Umodem.  These
functions (and their commands) are:

.SS UMODEM COMMAND MODE OPTIONS

.nf
Usage: r or s or option
Major Commands --
        rb <-- Receive Binary
        rt <-- Receive Text
        sb <-- Send Binary
        st <-- Send Text
Options --
        1  <-- (one) Employ TERM II FTP 1
        3  <-- Enable TERM FTP 3 (CP/M UG)
        7  <-- Toggle 7-bit transfer mask
        a  <-- Turn ON ARPA Net Flag
        l  <-- Toggle LOG File Entries
        m  <-- Allow file overwiting on receive
        x  <-- Exit
        y  <-- Display file status (size) information only

.fi
.SS UMODEM COMMAND MODE

	The following is a sample session illustrating what can be done
in the command mode of Umodem.

.nf
$ umodem -c

UMODEM Version 3.5 -- UNIX-Based Remote File Transfer Facility

UMODEM:  LOG File '/user/rxc/umodem.log' is Open

UMODEM Command Mode -- Type ? for Help
3  L  UMODEM> ?

Usage: r or s or option
Major Commands --
        rb <-- Receive Binary
        rt <-- Receive Text
        sb <-- Send Binary
        st <-- Send Text
Options --
        1  <-- (one) Employ TERM II FTP 1
        3  <-- Enable TERM FTP 3 (CP/M UG)
        7  <-- Enable 7-bit transfer mask
        a  <-- Turn ON ARPA Net Flag
        l  <-- Toggle LOG File Entries
        m  <-- Allow file overwiting on receive
        x  <-- Exit
        y  <-- Display file status (size) information only

3  L  UMODEM> 1

TERM FTP 1 Selected
1  L  UMODEM> m

File Overwriting  Enabled
1  LM UMODEM> m

File Overwriting NOT Enabled
1  L  UMODEM> 7

7-Bit Transfer  Selected
17 L  UMODEM> 7

7-Bit Transfer NOT Selected
1  L  UMODEM> y umodem.c

UMODEM File Status Display for umodem.c
  Estimated File Size 42K, 331 Records, 42252 Bytes

1  L  UMODEM> x

.fi
.SH FILES
umodem.log
	keeps a log of transfers to and from
and any problems during transfer.
.SH "SEE ALSO"
.SH AUTHOR
.nf
-- Lauren Weinstein, 6/81
-- (Version 2.0) Modified for JHU/UNIX by Richard Conn, 8/1/81
-- Version 2.1 Mods by Richard Conn, 8/2/81
-- Version 2.2 Mods by Richard Conn, 8/2/81
-- Version 2.3 Mods by Richard Conn, 8/3/81
-- Version 2.4 Mods by Richard Conn, 8/4/81
-- Version 2.5 Mods by Richard Conn, 8/5/81
-- Version 2.6 Mods by Bennett Marks, 8/21/81 (Bucky @ CCA-UNIX)
-- Version 2.7 Mods by Richard Conn, 8/25/81 (rconn @ BRL)
-- Version 2.8 Mods by Richard Conn, 8/28/81
-- Version 2.9 Mods by Richard Conn, 9/1/81
-- Version 3.0 Mods by Lauren Weinstein, 9/14/81
-- Version 3.1 Mods by Lauren Weinstein, 4/17/82
-- Version 3.2 Mods by Michael M Rubenstein, 5/26/83
-- Version 3.3 Mod by Ben Goldfarb, 07/02/83
-- Version 3.4 Mods by David F. Hinnant, NCECS, 7/15/83
-- Version 3.5 Mods by Richard Conn, 08/27/83

UMODEM.MAN -- Received From:

Received: From Ucb-Vax.ARPA by BRL via smtp;  6 Sep 83 9:11 EDT
Received: by ucbvax.ARPA (4.9/4.7)
	id AA21658; Tue, 6 Sep 83 06:11:52 PDT
Message-Id: <8309061311.AA21658@ucbvax.ARPA>
Date: 5-Sep-83 20:22:19-PDT (Mon)
Original-From: ucsfpgs!brian (#Brian Katzung)
From: ucsfcgl!ucsfpgs!brian@Berkeley (#Brian Katzung)
Subject: umodem.1
To: rconn@brl.ARPA

UMODEM.1 -- Modified by:

Richard Conn

.fi
