.TL
Changes to diff3
.PP
.DS
diff3 [-ex3EX] file1 file2 file3 [m1 m2]
.DE
I added 2 new options, -E and -X. They work like -e and -x, respectively,
in that they generate an edit script that incorporate into file1
changes between file2 and file3. However, the scripts generated by -E and
-X treat overlapping changes (those marked ==== by normal diff3)
differently.
.PP
If applied to file1, the scripts generated by -E and -X include, for every
pair of overlapping changes, BOTH sections of lines,
delimited with "<<<<<<<\ m1", 
"=======", and ">>>>>>>\ m2". M1 and m2 are markers supplied in the 
command. If they are omitted, file1 and file3 are used instead. 
.PP
Example: Suppose lines 7-8 are changed in both file1 and file2.
Applying the edit script generated by the command
.DS
"diff3 -E file1 file2 file3" 
.DE
to file 1 results in the following file:
.nf

lines 1-6
of file1
<<<<<<< file1
lines 7-8
of file1
=======
lines 7-8
of file3
>>>>>>> file3
rest of file1
.PP
The command
.DS
merge file1 file2 file3 [m1 m2]
.DE
performs a diff -E with the same arguments and applies the resulting edit 
script to file1. It also prints out the number of overlapping changes. 
