.TH SHOW 1 "3 August 1983"
.UC 4
.SH NAME
show \- show (list) messages
.SH SYNOPSIS
.B show
[ +folder ] [ msgs ] [ \-pr ] [ \-nopr ] [ \-draft ] [ \-help ]
[ \fIl\fR or \fIpr\fR switches ]
.SH DESCRIPTION
\fIShow\fR lists each of the specified messages to the standard
output (typically, the terminal).
The messages are listed exactly
as they are, with no reformatting.
A program called \fIl\fR is
invoked to do the listing, and any switches not recognized by
\fIshow\fR are passed along to \fIl\fR.
.PP
If no \*(lqmsgs\*(rq are specified, the current message is used.
If
more than one message is specified, \fIl\fR will prompt for a
<return> prior to listing each message.
.PP
\fIl\fR will list each message, a page at a time.
When the end of
page is reached, \fIl\fR will ring the bell and wait for a <RETURN>
or <CTRL-D>.
If a <return> is entered, \fIl\fR will clear the
screen before listing the next page, whereas <CTRL-D> will not.
The switches to \fIl\fR are
`\-p#' to indicate the page length in lines, and `\-w#' to
indicate the width of the page in characters.
.PP
If the standard output is not a terminal, no queries are made,
and each file is listed with a one-line header and two lines of
separation.
.PP
If `\-pr' is specified, then \fIpr\fR(I) will be invoked rather than
\fIl\fR, and the switches (other than `\-draft') will be passed
along.
\*(lqShow \-draft\*(rq will list the file <mh-dir>/draft if it
exists.
.SH FILES
.nf
.ta \w'$HOME/\*.mh\(ruprofile    'u
$HOME/\*.mh\(ruprofile	The user profile
/bin/l	Screen-at-a-time list program
/bin/pr	\fIpr\fR(1)
.fi
.SH "PROFILE COMPONENTS"
.nf
.ta \w'Current-Folder:    'u
Path:	To determine the user's MH directory
Current-Folder:	To find the default current folder
.fi
.SH DEFAULTS
.nf
`+folder' defaults to current
`msgs' defaults to cur
`\-nopr'
.fi
.SH CONTEXT
If a folder is given, it will become the current message.
The last message
listed will become the current message.
