#include "c42pdf.h"

void main(int argc, char *argv[])
{
    /*PDF variables*/ 
    PDF_info	*info;
    PDF         *p;
    options     *o;
    TIFF        *t;
    int optind; 

    t = (TIFF *)malloc(sizeof(TIFF));
    o = (options *)malloc(sizeof(options));

    info		= PDF_get_info();
    info->binary_mode	= true;

    optind = optionhandler(argc,argv,o);
    info->Creator = o->commandstring;   

    p = PDF_open(o->pdffile, info);

    while (optind++<argc || (o->listfile!=NULL && !feof(o->listfile)))
    {
    if (o->listfile!=NULL) /*process whitespace delimited list of input files*/
        {
        int i;
	char list_buffer[256], run = 1;
        for (i=0; i<255 && !feof(o->listfile) && run;)
          {
	  char c=0;
          while (c<=' ' && !feof(o->listfile)) c=getc(o->listfile);
          while (c>' ' && !feof(o->listfile))
	    {list_buffer[i]=c; c=getc(o->listfile);i++;}
          while (c<=' ' && !feof(o->listfile)) c=getc(o->listfile);
          if (!feof(o->listfile)) ungetc(c,o->listfile);
          run = 0; 
          }
        list_buffer[i]=0;
        if (strlen(list_buffer)>0) {
	  if ((t->tiffile = fopen(list_buffer,READMODE))==NULL) 
	    {printf("Error: cannot open TIFF file H%sH", list_buffer); exit(1);}
	/* #ifdef DEBUG*/
        printf("Processing %s.\n", list_buffer);
        /*#endif*/        
        }
	}
    else { 
      printf("Processing single file %s.\n", argv[optind-1]);
      if ((t->tiffile = fopen(argv[optind-1],READMODE))==NULL) { 
      printf("Error: cannot open TIFF file %s", argv[optind-1]); exit(1);}
    }
     readtifffile(p,t,o);
    }
    PDF_close(p);
    free(o);
    free(t);
}












