/* c42pdf.c Version 0.07 1999-04-21
 * a quick and dirty CCITT4 multipage 6.0 TIFF to PDF 1.1 converter. 
 * The program directly dumps compressed
 * TIFF data into PDF, it does NOT uncompress TIFF data, so it is fast!
 * By Holger Blasum (genba.ffii.org/~c42pdf) 1999.
 *
 * This application uses libpdf.a and modified source code from PDFlib, http://www.ifconnection.de/~tm  * (based on imagepdf.c). Copyright (C) 1997-98 Thomas Merz. 
 *
 */


/*#define DEBUG*//*uncommenting this increases transparency*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

/*PDFlib portability (Thomas Merz)*/
#ifdef POSIX
#include <unistd.h>
#endif
#ifdef DOS
#include <process.h>
#endif
#ifdef NeXT
#include <libc.h>	/* for getopt(), optind, optarg */
#endif

#include "pdf.h"
#include "p_intern.h"

/*definitions from Sam Leffler's TIFFLIB (tiff.h)*/
#define TIFFTAG_IMAGEWIDTH 256
#define TIFFTAG_IMAGELENGTH 257
#define TIFFTAG_COMPRESSION 259
#define COMPRESSION_CCITTFAX4 4
#define TIFFTAG_STRIPOFFSETS 273
#define TIFFTAG_FILLORDER 266
#define FILLORDER_MSB2LSB 1
#define FILLORDER_LSB2MSB 2
#define TIFFTAG_XRESOLUTION 282
#define TIFFTAG_YRESOLUTION 283
#define TIFFTAG_RESOLUTIONUNIT 296
#define RESUNIT_NONE 1
#define RESUNIT_INCH 2
#define RESUNIT_CENTIMETER 3
#define STRETCH_FALSE 0
#define STRETCH_TRUE 1
#define STRETCH_LOCK 2

typedef struct 
{
FILE *pdffile;
FILE *tiffile;
FILE *listfile;
char        commandstring[1000];
bool        caption, stretch, flip;
bool        fixedpapersize;
float       bottom; /*default: invalid bottom, downsized image will
            be centered by default*/
char        pdfname[256], tiffname[256]; /*PDF file default name*/
float       final_scale;
/*final scale reduction invoked by s options*/
float       paperheight, paperwidth;
float       crop[4];
int         repetitions,runs;
} options;

typedef struct
{
/*TIFF variables*/
FILE *      tiffile;
char        byteorder;
char        compressionfillorder;
int         compression; /*type of compression in TIFF file*/
int         resolutionunit;
double      xresolution, yresolution;
unsigned int imagewidth, imageheight;
 /*size of bitmap*/
long        thispagedatastart; /*offset of compressed image data begin for each image*/
long        thispagedataend;   /*offset of compressed image data end for each image*/
long        nextpageifdoffset; /*the point where a new image file directory (IFD) entry begins*/
long        pagecount;
} TIFF;


void C4_PDF_end_page(PDF *p, float crop[], int runs);
void helpme();

void C4_put_image(PDF *p, TIFF *t, options *o);

void C4_execute_image(PDF *p, TIFF *t, options *o);

void usage();
int flippit (PDF *p, TIFF *t, options *o);
float resolutionfactor(TIFF *t); 
long GetLong (FILE*tiffile,char fillorder);
int GetInt (FILE*tiffile,char fillorder);
int optionhandler(int argc, char *argv[], options* o);
void readtifffile(PDF *p, TIFF *t, options *o);
void readtiffpage(PDF *p, TIFF *t, options *o);
void handle_fancy_options(PDF *p, TIFF *t, options *o);












